/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers.locators;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FilenameFilter;
import java.util.logging.Logger;
import org.openqa.selenium.Platform;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.SingleBrowserLocator;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.WindowsUtils;

public class FirefoxLocator
extends SingleBrowserLocator {
    private static Logger LOGGER = Logger.getLogger(FirefoxLocator.class.getName());
    private static final String UBUNTU_BASE_DIR = "/usr/lib";
    private static final String[] USUAL_OS_X_LAUNCHER_LOCATIONS = new String[]{"/Applications/Firefox-3.app/Contents/MacOS", "/Applications/Firefox.app/Contents/MacOS"};
    private String[] usualLauncherLocations;

    @Override
    protected String browserPathOverridePropertyName() {
        return "firefoxDefaultPath";
    }

    @Override
    protected String browserName() {
        return "Firefox";
    }

    @Override
    protected String seleniumBrowserName() {
        return "firefox";
    }

    @Override
    protected String[] standardlauncherFilenames() {
        if (this.runningOnWindows()) {
            return new String[]{"firefox.exe"};
        }
        return new String[]{"firefox-bin", "firefox"};
    }

    @Override
    protected synchronized String[] usualLauncherLocations() {
        if (this.usualLauncherLocations == null) {
            this.usualLauncherLocations = this.runningOnWindows() ? this.firefoxDefaultLocationsOnWindows() : this.usualUnixLauncherLocations();
        }
        return this.usualLauncherLocations;
    }

    protected String[] usualUnixLauncherLocations() {
        String[] ubuntuLocations = this.firefoxDefaultLocationsOnUbuntu();
        if (ubuntuLocations.length == 0) {
            return USUAL_OS_X_LAUNCHER_LOCATIONS;
        }
        String[] ubuntoLocationPaths = new String[ubuntuLocations.length];
        int i = 0;
        while (i < ubuntuLocations.length) {
            ubuntoLocationPaths[i] = "/usr/lib/" + ubuntuLocations[i];
            ++i;
        }
        return ubuntoLocationPaths;
    }

    protected String[] firefoxDefaultLocationsOnUbuntu() {
        File dir2 = new File(UBUNTU_BASE_DIR);
        if (!dir2.exists() && dir2.isDirectory()) {
            return new String[0];
        }
        return dir2.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String name) {
                return name.startsWith("firefox-");
            }
        });
    }

    protected String[] firefoxDefaultLocationsOnWindows() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(WindowsUtils.getPathsInProgramFiles("\\Firefox-3"))).addAll(WindowsUtils.getPathsInProgramFiles("\\Mozilla Firefox"))).addAll(WindowsUtils.getPathsInProgramFiles("\\Firefox"))).build().toArray(new String[0]);
    }

    protected boolean runningOnWindows() {
        return Platform.getCurrent().is(Platform.WINDOWS);
    }

    @Override
    public String computeLibraryPath(File launcherPath) {
        if (this.runningOnWindows()) {
            return "";
        }
        StringBuilder libraryPath = new StringBuilder();
        String libraryPropertyName = CommandLine.getLibraryPathPropertyName();
        String existingLibraryPath = System.getenv(libraryPropertyName);
        if (Platform.getCurrent().is(Platform.MAC) && Platform.getCurrent().getMinorVersion() > 5) {
            libraryPath.append(existingLibraryPath);
        } else {
            libraryPath.append(launcherPath.getParent()).append(File.pathSeparator).append((CharSequence)libraryPath);
        }
        return libraryPath.toString();
    }

    @Override
    public BrowserInstallation findBrowserLocationOrFail() {
        LOGGER.fine("Discovering Firefox 3...");
        BrowserInstallation firefoxLocation = this.findBrowserLocation();
        if (firefoxLocation != null) {
            return firefoxLocation;
        }
        LOGGER.fine("Did not find Firefox 3, now searching PATH...");
        BrowserInstallation firefoxPathLocation = this.findBrowserLocationInPath();
        if (firefoxPathLocation != null) {
            return firefoxPathLocation;
        }
        throw new RuntimeException(this.couldNotFindAnyInstallationMessage());
    }

    public BrowserInstallation findBrowserLocationInPath() {
        String[] stringArray = this.standardlauncherFilenames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String executable = CommandLine.find(name);
            if (executable != null) {
                if (this.isScriptFile(new File(executable))) {
                    LOGGER.warning("Caution: '" + executable + "': file is a script file, not a real executable." + " The browser environment is no longer fully under RC control");
                }
                String libraryPathPropertyName = CommandLine.getLibraryPathPropertyName();
                String libraryPath = System.getenv(libraryPathPropertyName);
                return new BrowserInstallation(executable, libraryPath);
            }
            ++n2;
        }
        return null;
    }
}

