/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.naming;

import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import mx4j.tools.naming.NamingServiceMBean;

public class NamingService
implements NamingServiceMBean {
    private int m_port;
    private Registry m_registry;
    private boolean m_running;

    public NamingService() {
        this(1099);
    }

    public NamingService(int port) {
        this.setPort(port);
    }

    public void setPort(int port) {
        if (this.isRunning()) {
            throw new IllegalStateException("NamingService is running, cannot change the port");
        }
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public boolean isRunning() {
        return this.m_running;
    }

    public void start() throws RemoteException {
        if (!this.isRunning()) {
            this.m_registry = LocateRegistry.createRegistry(this.getPort());
            this.m_running = true;
        }
    }

    public void stop() throws NoSuchObjectException {
        if (this.isRunning()) {
            this.m_running = !UnicastRemoteObject.unexportObject(this.m_registry, true);
        }
    }

    public String[] list() throws RemoteException {
        if (!this.isRunning()) {
            throw new IllegalStateException("NamingService is not running");
        }
        return this.m_registry.list();
    }

    public void unbind(String name) throws RemoteException, NotBoundException {
        if (!this.isRunning()) {
            throw new IllegalStateException("NamingService is not running");
        }
        this.m_registry.unbind(name);
    }
}

