/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.EOFException;
import org.openqa.jetty.http.HttpContext;
import org.openqa.jetty.http.HttpException;
import org.openqa.jetty.http.HttpInputStream;
import org.openqa.jetty.http.HttpListener;
import org.openqa.jetty.http.HttpOutputStream;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.http.HttpServer;
import org.openqa.jetty.http.HttpTunnel;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.LineInput;
import org.openqa.jetty.util.LogSupport;
import org.openqa.jetty.util.OutputObserver;
import org.openqa.jetty.util.StringUtil;

public class HttpConnection
implements OutputObserver {
    private static Log log = LogFactory.getLog(HttpConnection.class);
    private static ThreadLocal __threadConnection = new ThreadLocal();
    private static boolean __2068_Continues = Boolean.getBoolean("org.openqa.jetty.http.HttpConnection.2068Continue");
    protected HttpRequest _request;
    protected HttpResponse _response;
    protected boolean _persistent;
    protected boolean _keepAlive;
    protected int _dotVersion;
    private HttpListener _listener;
    private HttpInputStream _inputStream;
    private HttpOutputStream _outputStream;
    private boolean _close;
    private boolean _firstWrite;
    private boolean _completing;
    private Thread _handlingThread;
    private InetAddress _remoteInetAddress;
    private String _remoteAddr;
    private String _remoteHost;
    private HttpServer _httpServer;
    private Object _connection;
    private boolean _throttled;
    private boolean _statsOn;
    private long _tmpTime;
    private long _openTime;
    private long _reqTime;
    private int _requests;
    private Object _object;
    private HttpTunnel _tunnel;
    private boolean _resolveRemoteHost;

    public HttpConnection(HttpListener listener, InetAddress remoteAddr, InputStream in, OutputStream out, Object connection) {
        if (log.isDebugEnabled()) {
            log.debug("new HttpConnection: " + connection);
        }
        this._listener = listener;
        this._remoteInetAddress = remoteAddr;
        int bufferSize = listener == null ? 4096 : listener.getBufferSize();
        int reserveSize = listener == null ? 512 : listener.getBufferReserve();
        this._inputStream = new HttpInputStream(in, bufferSize);
        this._outputStream = new HttpOutputStream(out, bufferSize, reserveSize);
        this._outputStream.addObserver(this);
        this._firstWrite = false;
        if (this._listener != null) {
            this._httpServer = this._listener.getHttpServer();
        }
        this._connection = connection;
        boolean bl = this._statsOn = this._httpServer != null && this._httpServer.getStatsOn();
        if (this._statsOn) {
            this._openTime = System.currentTimeMillis();
            this._httpServer.statsOpenConnection();
        }
        this._reqTime = 0L;
        this._requests = 0;
        this._request = new HttpRequest(this);
        this._response = new HttpResponse(this);
        this._resolveRemoteHost = this._listener != null && this._listener.getHttpServer() != null && this._listener.getHttpServer().getResolveRemoteHost();
    }

    static HttpConnection getHttpConnection() {
        return (HttpConnection)__threadConnection.get();
    }

    public InetAddress getRemoteInetAddress() {
        return this._remoteInetAddress;
    }

    public String getRemoteAddr() {
        if (this._remoteAddr == null) {
            if (this._remoteInetAddress == null) {
                return "127.0.0.1";
            }
            this._remoteAddr = this._remoteInetAddress.getHostAddress();
        }
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        if (this._remoteHost == null) {
            if (this._resolveRemoteHost) {
                if (this._remoteInetAddress == null) {
                    return "localhost";
                }
                this._remoteHost = this._remoteInetAddress.getHostName();
            } else {
                if (this._remoteInetAddress == null) {
                    return "127.0.0.1";
                }
                this._remoteHost = this.getRemoteAddr();
            }
        }
        return this._remoteHost;
    }

    public HttpInputStream getInputStream() {
        return this._inputStream;
    }

    public HttpOutputStream getOutputStream() {
        return this._outputStream;
    }

    public Object getConnection() {
        return this._connection;
    }

    public HttpRequest getRequest() {
        return this._request;
    }

    public HttpResponse getResponse() {
        return this._response;
    }

    public void forceClose() {
        this._persistent = false;
        this._close = true;
    }

    public void close() throws IOException {
        try {
            this._completing = true;
            if (this._connection instanceof Socket && !(this._connection instanceof SSLSocket)) {
                ((Socket)this._connection).shutdownOutput();
            }
            this._outputStream.close();
            this._inputStream.close();
        }
        finally {
            if (this._handlingThread != null && Thread.currentThread() != this._handlingThread) {
                this._handlingThread.interrupt();
            }
        }
    }

    public HttpListener getListener() {
        return this._listener;
    }

    public HttpServer getHttpServer() {
        return this._httpServer;
    }

    public String getDefaultScheme() {
        return this._listener.getDefaultScheme();
    }

    public String getServerName() {
        String host = this._listener.getHost();
        if ("0.0.0.0".equals(host) && this._connection instanceof Socket) {
            host = ((Socket)this._connection).getLocalAddress().getHostName();
        }
        return host;
    }

    public String getServerAddr() {
        if (this._connection instanceof Socket) {
            return ((Socket)this._connection).getLocalAddress().getHostAddress();
        }
        return this._listener.getHost();
    }

    public int getServerPort() {
        return this._listener.getPort();
    }

    public int getRemotePort() {
        if (this._connection instanceof Socket) {
            return ((Socket)this._connection).getPort();
        }
        return 0;
    }

    public boolean isThrottled() {
        return this._throttled;
    }

    public void setThrottled(boolean throttled) {
        this._throttled = throttled;
    }

    public Object getObject() {
        return this._object;
    }

    public void setObject(Object o) {
        this._object = o;
    }

    public HttpTunnel getHttpTunnel() {
        return this._tunnel;
    }

    public void setHttpTunnel(HttpTunnel tunnel) {
        this._tunnel = tunnel;
    }

    private void verifyHTTP_1_0() {
        int content_length = this._request.getIntField("Content-Length");
        if (content_length >= 0) {
            this._inputStream.setContentLength(content_length);
        } else if (content_length < 0) {
            this._inputStream.setContentLength(0);
        }
        if (!this._keepAlive && "keep-alive".equalsIgnoreCase(this._request.getField("Proxy-Connection"))) {
            this._keepAlive = true;
        }
        this._persistent = this._keepAlive;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyHTTP_1_1() throws HttpException, IOException {
        String expect;
        String host = this._request.getField("Host");
        if (host == null) {
            throw new HttpException(400);
        }
        String transfer_coding = this._request.getField("Transfer-Encoding");
        if (transfer_coding != null && transfer_coding.length() > 0) {
            if (transfer_coding.equalsIgnoreCase("chunked") || StringUtil.endsWithIgnoreCase(transfer_coding, "chunked")) {
                this._inputStream.setChunking();
            } else if (StringUtil.asciiToLowerCase(transfer_coding).indexOf("chunked") >= 0) {
                throw new HttpException(400);
            }
        }
        int content_length = this._request.getIntField("Content-Length");
        String content_type = this._request.getField("Content-Type");
        if (!this._inputStream.isChunking()) {
            if (content_length >= 0) {
                this._inputStream.setContentLength(content_length);
            } else if (content_type == null || content_type.length() == 0) {
                this._inputStream.setContentLength(0);
            } else {
                this._inputStream.setContentLength(0);
            }
        }
        if ((expect = this._request.getField("Expect")) != null && expect.length() > 0) {
            if (!StringUtil.asciiToLowerCase(expect).equals("100-continue")) throw new HttpException(417);
            this._inputStream.setExpectContinues(this._outputStream.getOutputStream());
        } else if (__2068_Continues && this._inputStream.available() <= 0 && ("PUT".equals(this._request.getMethod()) || "POST".equals(this._request.getMethod()))) {
            OutputStream real_out = this._outputStream.getOutputStream();
            real_out.write(HttpResponse.__Continue);
            real_out.flush();
        }
        this._persistent = !this._close;
    }

    @Override
    public void outputNotify(OutputStream out, int action, Object ignoredData) throws IOException {
        if (this._response == null) {
            return;
        }
        switch (action) {
            case 0: {
                if (this._firstWrite) break;
                this.firstWrite();
                this._firstWrite = true;
                break;
            }
            case 1: {
                this.resetBuffer();
                break;
            }
            case 2: {
                this.commit();
                break;
            }
            case 4: {
                if (this._response == null) break;
                this.completing();
                if (this._response.isCommitted() || this._request.getState() != 2) break;
                this.commit();
                break;
            }
        }
    }

    protected void firstWrite() throws IOException {
        int length;
        if (this._response.isCommitted()) {
            return;
        }
        if ("HEAD".equals(this._request.getMethod())) {
            this._outputStream.nullOutput();
        }
        if ((length = this._response.getIntField("Content-Length")) >= 0) {
            this._outputStream.setContentLength(length);
        }
    }

    private void resetBuffer() {
    }

    void completing() {
        this._completing = true;
    }

    protected void commit() throws IOException {
        if (this._response.isCommitted()) {
            return;
        }
        int status = this._response.getStatus();
        int length = -1;
        if (this._inputStream.getExpectContinues() != null) {
            this._inputStream.setExpectContinues(null);
            this._inputStream.unsafeSetContentLength(0);
        }
        boolean has_close = "close".equals(this._response.getField("Connection"));
        if (!this._persistent || this._close || this._listener != null && (!this._listener.isStarted() || this._listener.isOutOfResources())) {
            this._close = true;
            if (!has_close) {
                this._response.setField("Connection", "close");
            }
            has_close = true;
        }
        if (this._close) {
            this._persistent = false;
        }
        if (this._persistent) {
            switch (this._dotVersion) {
                case 1: {
                    String transfer_coding = this._response.getField("Transfer-Encoding");
                    if (transfer_coding == null || transfer_coding.length() == 0 || "identity".equalsIgnoreCase(transfer_coding)) {
                        if (status == 304 || status == 204 || this._response.getField("Content-Length") != null) break;
                        if (this._completing) {
                            length = this._outputStream.getBytesWritten();
                            this._response.setContentLength(length);
                            break;
                        }
                        this._response.setField("Transfer-Encoding", "chunked");
                        this._outputStream.setChunking();
                        break;
                    }
                    this._response.removeField("Content-Length");
                    this._outputStream.setChunking();
                    if ("chunked".equalsIgnoreCase(transfer_coding)) break;
                    List te = this._request.getAcceptableTransferCodings();
                    Enumeration enm = this._response.getFieldValues("Transfer-Encoding", ", \t");
                    while (enm.hasMoreElements()) {
                        String coding = (String)enm.nextElement();
                        if ("identity".equalsIgnoreCase(coding) || "chunked".equalsIgnoreCase(coding) || te != null && te.contains(coding)) continue;
                        throw new HttpException(501, coding);
                    }
                    break;
                }
                case 0: {
                    this._response.removeField("Transfer-Encoding");
                    if (this._keepAlive) {
                        if (status != 304 && status != 204 && this._response.getField("Content-Length") == null) {
                            if (this._completing) {
                                length = this._outputStream.getBytesWritten();
                                this._response.setContentLength(length);
                                this._response.setField("Connection", "keep-alive");
                                break;
                            }
                            this._response.setField("Connection", "close");
                            this._close = true;
                            has_close = true;
                            this._persistent = false;
                            break;
                        }
                        this._response.setField("Connection", "keep-alive");
                        break;
                    }
                    if (has_close) break;
                    this._response.setField("Connection", "close");
                    break;
                }
                default: {
                    this._close = true;
                    this._persistent = false;
                    this._keepAlive = false;
                }
            }
        }
        this._request.setHandled(true);
        this._outputStream.writeHeader(this._response);
        this._outputStream.flush();
    }

    private void exception(Throwable e) {
        try {
            this._persistent = false;
            int error_code = 500;
            if (e instanceof HttpException) {
                error_code = ((HttpException)e).getCode();
                if (this._request == null) {
                    log.warn(e.toString());
                } else {
                    log.warn(String.valueOf(this._request.getRequestLine()) + " " + e.toString());
                }
                log.debug("EXCEPTION ", e);
            } else {
                if (e instanceof EOFException) {
                    LogSupport.ignore(log, e);
                    return;
                }
                this._request.setAttribute("javax.servlet.error.exception_type", e.getClass());
                this._request.setAttribute("javax.servlet.error.exception", e);
                if (this._request == null) {
                    log.warn("EXCEPTION ", e);
                } else {
                    log.warn(this._request.getRequestLine(), e);
                }
            }
            if (this._response != null && !this._response.isCommitted()) {
                this._response.reset();
                this._response.removeField("Transfer-Encoding");
                this._response.setField("Connection", "close");
                this._response.sendError(error_code);
            }
        }
        catch (Exception ex) {
            LogSupport.ignore(log, ex);
        }
    }

    protected HttpContext service(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (this._httpServer == null) {
            throw new HttpException(503);
        }
        return this._httpServer.service(request, response);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void handle() {
        try {
            block6: {
                block5: {
                    this.associateThread();
                    if (!true) break block5;
                    if (!this._listener.isStarted()) return;
                    if (!this.handleNext()) break block6;
                }
                do {
                    this.recycle();
                    if (!this._listener.isStarted()) return;
                } while (this.handleNext());
            }
            return;
        }
        finally {
            this.disassociateThread();
            this.destroy();
        }
    }

    protected void associateThread() {
        __threadConnection.set(this);
        this._handlingThread = Thread.currentThread();
    }

    protected void disassociateThread() {
        this._handlingThread = null;
        __threadConnection.set(null);
    }

    protected void readRequest() throws IOException {
        this._request.readHeader((LineInput)this._inputStream.getInputStream());
    }

    /*
     * Exception decompiling
     */
    public boolean handleNext() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void statsRequestStart() {
        if (this._statsOn) {
            if (this._reqTime > 0L) {
                this.statsRequestEnd();
            }
            ++this._requests;
            this._reqTime = this._tmpTime = this._request.getTimeStamp();
            this._httpServer.statsGotRequest();
        }
    }

    protected void statsRequestEnd() {
        if (this._statsOn && this._reqTime > 0L) {
            this._httpServer.statsEndRequest(System.currentTimeMillis() - this._reqTime, this._response != null);
            this._reqTime = 0L;
        }
    }

    protected void recycle() {
        this._listener.persistConnection(this);
        if (this._request != null) {
            this._request.recycle(this);
        }
        if (this._response != null) {
            this._response.recycle(this);
        }
    }

    protected void destroy() {
        try {
            this.close();
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", e);
        }
        if (this._request != null) {
            this._request.destroy();
        }
        if (this._response != null) {
            this._response.destroy();
        }
        if (this._inputStream != null) {
            this._inputStream.destroy();
        }
        if (this._outputStream != null) {
            this._outputStream.destroy();
        }
        this._inputStream = null;
        this._outputStream = null;
        this._request = null;
        this._response = null;
        this._handlingThread = null;
        if (this._statsOn) {
            this._tmpTime = System.currentTimeMillis();
            if (this._reqTime > 0L) {
                this._httpServer.statsEndRequest(this._tmpTime - this._reqTime, false);
            }
            this._httpServer.statsCloseConnection(this._tmpTime - this._openTime, this._requests);
        }
    }
}

