import { shallowMount, createLocalVue } from '@vue/test-utils';
import Router from 'vue-router'
import Header from '../src/components/Header.vue';
import Vuex from 'vuex';
import '../src/firebase';

const localVue = createLocalVue();
localVue.use(Vuex);
localVue.use(Router);

describe('Header.vue', () => {
  let store;
  let getters;
  let mutations;
  beforeEach(() => {
    getters = {
      session: () => false
    }
    mutations = {
      SET_SESSION: () => {}
    }
    store = new Vuex.Store({
      getters,
      mutations
    })
 
  })

  it('Sprawdzam, czy wartość właściwości została prawiłowo przekazana do komponentu Header', () => {
    const cartItemCount = 10;
    const wrapper = shallowMount(Header, {
      store, localVue, propsData: { cartItemCount }
    })
    expect(wrapper.vm.cartItemCount).toBe(cartItemCount);
  })

  it('Sprawdzam, czy wartość cartItemCount została prawidłowo wyświetlona', () => {
    const cartItemCount = 10;
    const wrapper = shallowMount(Header, {
      store, localVue, propsData: { cartItemCount }
    })
    const p = wrapper.find('span');
    expect(p.text()).toContain(cartItemCount)
  })

  it('Sprawdzam, czy do pierwszego elementu div została dodana klasa navbar', () => {
    const cartItemCount = 10;
    const wrapper = shallowMount(Header, {
      store, localVue, propsData: { cartItemCount }
    })
    const p = wrapper.findAll('div').at(0);
    expect(p.classes()).toContain('navbar');
  })

  it('Sprawdzam, czy tekst na przycisku do logowania jest prawidłowy', () => {
    const cartItemCount = 10;
    const wrapper = shallowMount(Header, {
      store, localVue, propsData: { cartItemCount }
    })

    expect(wrapper.findAll('button').at(0).text()).toBe("Logowanie");

  })
  it('Sprawdzam, czy tekst na przycisku do wylogowania jest prawidłowy', () => {
      const cartItemCount = 10;
      getters.session = () => true;
      store = new Vuex.Store({ getters, mutations})
    const wrapper = shallowMount(Header, {
        store, localVue, propsData: { cartItemCount }
      })
      debugger;
      expect(wrapper.findAll('button').at(0).text()).toBe("Wyloguj");
  })


});
