﻿Module Module1
  Class Program

    Shared WaitHandle As New AutoResetEvent(False)
    Shared _userId As String
    Shared _expenseReportId As Guid

    Shared Sub Main()

      Using workflowRuntime As New WorkflowRuntime()
        AddHandler workflowRuntime.WorkflowCompleted, _
          AddressOf OnWorkflowCompleted
        AddHandler workflowRuntime.WorkflowTerminated, _
          AddressOf OnWorkflowTerminated

                'Tworzenie obiektu do obsługi wymiany danych.
        Dim exchangeServ As New ExternalDataExchangeService()
        workflowRuntime.AddService(exchangeServ)

                'Konfigurowanie komunikacji z czynnością HandleExternalEvent.
        Dim approvalMgr As New ManageApproval()
        exchangeServ.AddService(approvalMgr)
        Dim paymentMgr As New ManagePayment()
        exchangeServ.AddService(paymentMgr)

                Console.Write("Wpisz nazwę użytkownika: ")
        _userId = Console.ReadLine()

        Dim wfParams As New Dictionary(Of String, Object)
        wfParams.Add("UserId", _userId)
        Dim expenseId As Guid = Guid.NewGuid()
        wfParams.Add("ExpenseReportId", expenseId)

        Dim workflowInstance As WorkflowInstance
        workflowInstance = workflowRuntime.CreateWorkflow( _
        GetType(ExpenseReport), wfParams)

        workflowInstance.Start()
                Console.WriteLine("Uruchomiono proces: " + _
                          workflowInstance.InstanceId.ToString())

                'Oczekiwanie na przesłanie powiadomienia przez proces.
        Thread.Sleep(500)

                'Pobranie decyzji.
                Console.Write( _
                  "Wpisz 'zatwierdzam', aby zatwierdzić, i inny tekst, aby odrzucić raport: ")
        Dim approval As String = Console.ReadLine()
                If approval = "zatwierdzam" Then
                    approvalMgr.ApproveExpenseReport(expenseId, True, _
                                                     workflowInstance.InstanceId)

                    'Oczekiwanie na powiadomienie od działu finansów.
                    Thread.Sleep(500)

                    Console.Write("Wpisz numer kontrolny (int): ")
                    Dim checkNbr As String = Console.ReadLine()
                    paymentMgr.ProcessPayment(expenseId, Integer.Parse(checkNbr), _
                                              workflowInstance.InstanceId)

                Else
                    approvalMgr.ApproveExpenseReport(expenseId, False, _
                                                     workflowInstance.InstanceId)
                End If

        WaitHandle.WaitOne()
        Console.WriteLine("")
                Console.WriteLine("Wciśnij Enter, aby zakończyć.")
        Console.ReadLine()

      End Using

    End Sub

    Shared Sub OnWorkflowCompleted(ByVal sender As Object, _
                                   ByVal e As WorkflowCompletedEventArgs)
      WaitHandle.Set()
            Console.WriteLine("Koniec procesu.")
    End Sub

    Shared Sub OnWorkflowTerminated(ByVal sender As Object, _
      ByVal e As WorkflowTerminatedEventArgs)
      Console.WriteLine(e.Exception.Message)
      WaitHandle.Set()
    End Sub

  End Class

End Module

