﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Forms;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Effects;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace ImageViewer
{
	/// <summary>
	/// Interaction logic for Window1.xaml
	/// </summary>
	public partial class Window1 : Window
	{
		private DirectoryImageList _imgList;
		private string _path = Environment.GetFolderPath(Environment.SpecialFolder.MyPictures);

		public Window1()
		{
			InitializeComponent();
			ResetList();
			this.DataContext = _imgList.Images;
		}

		private void FolderOpenMenuItem_Click(object sender, RoutedEventArgs e)
		{
			SetPath();
		}

		private void SetPath()
		{
			FolderBrowserDialog dlg = new FolderBrowserDialog();
			dlg.ShowDialog();
			_path = dlg.SelectedPath;
			ResetList();
		}

		private void ResetList()
		{
			if (IsValidPath(_path))
			{
				_imgList = new DirectoryImageList(_path);
			}

			this.DataContext = _imgList.Images;

		}

		private bool IsValidPath(string path)
		{
			
			try
			{
				string folder = System.IO.Path.GetFullPath(path);
				return true;
			}
			catch
			{
				return false;
			}
		}

		private void buttonBandW_Click(object sender, RoutedEventArgs e)
		{
			BitmapSource img = (BitmapSource)image1.Source;
			image1.Source = new FormatConvertedBitmap(img, PixelFormats.Gray16, BitmapPalettes.Gray256, 1.0);
		}

		private void buttonBlur_Click(object sender, RoutedEventArgs e)
		{
			if (image1.BitmapEffect != null)
			{
				// Jeśli zastosowano już efekt, należy go usunąć.
				image1.BitmapEffect = null;
			}
			else
			{
				// W przeciwnym razie należy zastosować efekt.
				image1.BitmapEffect = new BlurBitmapEffect();
			}
		}

		private void buttonRotate_Click(object sender, RoutedEventArgs e)
		{
			CachedBitmap cache = new CachedBitmap((BitmapSource)image1.Source, BitmapCreateOptions.None, BitmapCacheOption.OnLoad);
			image1.Source = new TransformedBitmap(cache, new RotateTransform(90));
		}

		private void buttonFlip_Click(object sender, RoutedEventArgs e)
		{
			CachedBitmap cache = new CachedBitmap((BitmapSource)image1.Source, BitmapCreateOptions.None, BitmapCacheOption.OnLoad);
			ScaleTransform scale = new ScaleTransform(-1, -1, image1.Source.Width / 2, image1.Source.Height / 2);
			image1.Source = new TransformedBitmap(cache, scale);
		}

		private void listBox1_SelectionChanged(object sender, SelectionChangedEventArgs e)
		{
			image1.Source = (BitmapSource)((sender as System.Windows.Controls.ListBox).SelectedItem);
		}

	}
}
