﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Media;
using System.Windows.Media.Imaging;

namespace ImageViewer
{
    /// <summary>
    /// Reprezentuje obrazy, do których prowadzi określona ścieżka.
    /// </summary>
	public class DirectoryImageList
	{
		private string _path;
		private List<BitmapSource> _images = new List<BitmapSource>();

		public DirectoryImageList(string path)
		{
			_path = path;
			LoadImages();
		}

        /// <summary>
        /// Pobiera obiekt typu List<BitmapSource> zawierający wszystkie rysunki 
        /// z lokalizacji określonej przez zmienną Path.
        /// </summary>
		public List<BitmapSource> Images
		{
            get { return _images; }
		}

        /// <summary>
        /// Służy do pobierania i ustawiania ścieżki do folderu z obrazami.
        /// </summary>
		public string Path
		{
			get { return _path; }
			set 
			{ 
				_path = value;
				LoadImages();		
			}
		}

        /// <summary>
        /// Wyszukuje pliki z rysunkami w folderze wskazanym przez ścieżkę 
        /// i ustawia obiekt _images.
        /// </summary>
		private void LoadImages()
		{
			_images.Clear();
			BitmapImage img;

			foreach (string file in Directory.GetFiles(_path))
			{
				try
				{
					img = new BitmapImage(new Uri(file));
					
					_images.Add(img);

				}
				catch
				{
                    // Pusty blok catch. Aplikacja ignoruje wszystkie pliki,
                    // które nie zawierają rysunków. 
				}


			}

		}

	}
}
