﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Workflow.Runtime;
using System.Workflow.Runtime.Hosting;
using System.Workflow.Activities;

namespace TravelRequestWf {
  class Program {

    private static AutoResetEvent _waitHandle = new AutoResetEvent(false);
    private static string _userName;
    private static double _travleCost;
    private static int _requestId;

    private static void EnterTravelRequest() {

      //Definiowanie parametrów procesu.
        Console.Write("Wpisz nazwę użytkownika (>6 = menedżer): ");
      _userName = Console.ReadLine();

      Console.Write("Podaj koszt wyjazdu (typ double): ");
      string cost = Console.ReadLine();
      _travleCost = double.Parse(cost);

      Console.Write("Podaj identyfikator wyjazdu (typ int): ");
      string id = Console.ReadLine();
      _requestId = int.Parse(id);

    }

    static void Main(string[] args) {

      using (WorkflowRuntime workflowRuntime = new WorkflowRuntime()) {

          //Tworzenie obiektu do wymiany danych.
        ExternalDataExchangeService exchangeServ = new ExternalDataExchangeService();
        workflowRuntime.AddService(exchangeServ);

        //Konfigurowanie komunikacji z czynnością CallExternalMethod. 
        exchangeServ.AddService(new UserProfile());
        exchangeServ.AddService(new Notification());

        //Konfigurowanie komunikacji z udziałem czynności HandleExternalEvent.
        ManageApproval approvalMgr = new ManageApproval();
        exchangeServ.AddService(approvalMgr);

        //Podłączanie zdarzeń procesu.
        workflowRuntime.WorkflowCompleted += OnWorkflowComplete;        
        workflowRuntime.WorkflowTerminated += OnWorkflowTerminated;

        //Pobieranie danych od użytkownika.
        EnterTravelRequest();

        //Parametry konfiguracyjne.
        Dictionary<string, object> wfParams = new Dictionary<string, object>();
        wfParams.Add("TravelRequestor", _userName);
        wfParams.Add("TravelCost", _travleCost);
        wfParams.Add("TravelRequestId", _requestId);

        //Oczekiwanie na polecenia użytkownika.
        Console.WriteLine("Wciśnij Enter, aby uruchomić proces.");
        Console.ReadLine();

        //Tworzenie egzemplarza procesu.
        WorkflowInstance instance = workflowRuntime.CreateWorkflow(
          typeof(TravelRequestWf.TravelRequestProcess), wfParams);

        //Uruchamianie procesu.
        instance.Start();
        Console.WriteLine("Uruchomiono proces: " + instance.InstanceId.ToString());

        //Wstrzymanie działania na czas uruchamiania procesu.
        Thread.Sleep(300);

        //Sprawdzanie, czy proces czeka na akceptację (kod testowy).
        if(IsWaitingOnApproval()) {
          Console.Write(            "Wpisz 'zatwierdzam', aby zaakceptować (inny tekst oznacza odrzucenie zgłoszenia): ");

          string approval = Console.ReadLine();

          if(approval == "zatwierdzam") {
            approvalMgr.ApproveTravel(_requestId, true, instance.InstanceId);
          } else {
            approvalMgr.ApproveTravel(_requestId, false, instance.InstanceId);
          }
        }

        _waitHandle.WaitOne();
        Console.WriteLine("");
        Console.WriteLine("Wciśnij Enter, aby zakończyć.");       
        Console.ReadLine();

      }
    }

    private static bool IsWaitingOnApproval() {

        // To tylko kod testowy, a nie prawdziwy klient. 

        // Sprawdzanie, czy proces oczekuje na zatwierdzenie zgłoszenia.
      UserProfile userProfile = new UserProfile();

      //Jeśli użytkownik nie jest menedżerem, potrzebne jest zatwierdzenie.
      if (!userProfile.IsUserManager(_userName)) {
        return true;
      } else if (_travleCost > 1500) {
          return true;
        } else {
          return false;
        }
    }

    private static void OnWorkflowComplete(object sender, 
      WorkflowCompletedEventArgs e) {
          Console.WriteLine("Koniec procesu: " + 
        e.WorkflowInstance.InstanceId.ToString());
      _waitHandle.Set(); 
    }

    private static void OnWorkflowTerminated(object sender, 
      WorkflowTerminatedEventArgs e) {
          Console.WriteLine("Koniec procesu: " +
        e.WorkflowInstance.InstanceId + ". Komunikat: " +e.Exception.Message);
      _waitHandle.Set();
    }

  }
}
