﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TravelRequestWf {
  
  [Serializable]
  class ManageApproval : IApproval {

    public event EventHandler<ApprovalEventArgs> Approval;

    public void ApproveTravel(int travelId, 
      bool isApproved, Guid wfInstanceId) {

          //Sprawdzanie, czy istnieją subskrybenci zdarzenia.
      if (Approval != null) {

          //Tworzenie nowych argumentów zdarzenia i określenie stanu akceptacji.
        ApprovalEventArgs approvalArgs = new ApprovalEventArgs(wfInstanceId);        
        approvalArgs.IsApproved = isApproved;

        //Wywoływanie zdarzenia i przekazanie jednostki zgłaszającej.
        Approval(this, approvalArgs);
      
      }    
    }

  }
}
