namespace DateTimerPickerForm
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            this.Text = "DateTimePickerForm";
            this.Width = 345;
            this.Height = 158;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.StartPosition = FormStartPosition.CenterScreen;
            this.FormBorderStyle = FormBorderStyle.FixedSingle;

            // dateTimePicker
            DateTimePicker dateTimePicker1 = new DateTimePicker();
            dateTimePicker1.Size = new Size(300, 25);
            dateTimePicker1.Location = new Point(12, 12);
            dateTimePicker1.Name = "dateTimePicker1";

            dateTimePicker1.MinDate = new DateTime(2015, 1, 1);
            dateTimePicker1.MaxDate = DateTime.Today;

            dateTimePicker1.CustomFormat = "yyyy-MM-dd";
            dateTimePicker1.Format = DateTimePickerFormat.Custom;

            //dateTimePicker1.ShowCheckBox = true;
            //dateTimePicker1.ShowUpDown = true;

            this.Controls.Add(dateTimePicker1);

            // Button
            Button firstButton = new Button();
            firstButton.Location = new Point(12, 54);
            firstButton.Text = "Get Day Of Week";

            firstButton.Height = 35;
            firstButton.Width = 300;

            firstButton.Click += new EventHandler(firstButton_Click);

            Controls.Add(firstButton);
        }

        private void firstButton_Click(object sender, EventArgs e)
        {
            try
            {
                if (((DateTimePicker)Controls["dateTimePicker1"]).Value != null)
                {
                    DateTime GetDateAndTime = ((DateTimePicker)Controls["dateTimePicker1"]).Value;

                    MessageBox.Show(GetDateAndTime.DayOfWeek.ToString(), "Selected", MessageBoxButtons.OK);
                }

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK);
            }
        }
    }
}