namespace FolderBrowserDialogForm
{
    public partial class Form1 : Form
    {
        FolderBrowserDialog folderBrowserDialog1 = new FolderBrowserDialog();
        public Form1()
        {
            InitializeComponent();

            this.Text = "FolderBrowsingDialogForm";
            this.Width = 305;
            this.Height = 116;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.StartPosition = FormStartPosition.CenterScreen;
            this.FormBorderStyle = FormBorderStyle.FixedSingle;

            folderBrowserDialog1.Description = "Specify the folder in which to search for files.";

            folderBrowserDialog1.ShowNewFolderButton = false;

            Button OpenFolderButton = new Button();
            OpenFolderButton.Location = new Point(12, 12);
            OpenFolderButton.Name = "OpenFolderButton";
            OpenFolderButton.Size = new Size(260, 35);
            OpenFolderButton.TabIndex = 1;
            OpenFolderButton.Text = "Open Folder";
            OpenFolderButton.UseVisualStyleBackColor = true;
            OpenFolderButton.Click += new EventHandler(OpenFolderButton_Click);
            Controls.Add(OpenFolderButton);
        }

        private void OpenFolderButton_Click(object sender, EventArgs e)
        {
            try
            {
                folderBrowserDialog1.RootFolder = Environment.SpecialFolder.MyDocuments;

                DialogResult resultOfDialog = folderBrowserDialog1.ShowDialog();

                if (resultOfDialog == DialogResult.OK)
                {
                    MessageBox.Show(folderBrowserDialog1.SelectedPath, "Selected Path", MessageBoxButtons.OK);
                }

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK);
            }
        }
    }
}