﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using FeedbackData;
using Microsoft.WindowsAzure;
using Microsoft.WindowsAzure.ServiceRuntime;
using Microsoft.WindowsAzure.StorageClient;
using System.Net;

namespace UnleashedFeedbackWeb.admin
{
  public partial class ViewFeedback : System.Web.UI.Page
  {
    protected void Page_Load(object sender, EventArgs e)
    {
      if (!IsPostBack)
      {
        string partition = DateTime.UtcNow.ToString("MMyyyy");
        SetPartition(partition);
      }
    }

    protected void SetPartition(string partition)
    {
        // Ustawianie domyślnej partycji na bieżący rok i dzień.
      TextBoxPartition.Text = partition;
      LabelDataPartition.Text = "Dane z partycji: " + partition;
      ObjectDataSource1.SelectParameters["partitionMmYyyy"].DefaultValue = partition;
      ObjectDataSource1.DataBind();
    }

    protected void ButtonMarkReplied_Click(object sender, EventArgs e)
    {
        // Pobieranie klucza wiersza i danych dla wybranego elementu.

        // Tworzenie źródła danych z informacjami zwrotnymi.
      FeedbackDataSource fDs = new FeedbackDataSource();

      // Do zrobienia: zwiększenie niezawodności.
      string partitionKey = TextBoxPartition.Text;
      string rowKey = GridView1.SelectedRow.Cells[7].Text;

      // Oznaczanie, że udzielono odpowiedzi.
      fDs.SetReplySent(partitionKey, rowKey);

      this.PanelMain.Visible = false;
      this.PanelFinished.Visible = true;

    }

  }
}