﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.WindowsAzure;
using Microsoft.WindowsAzure.StorageClient;

namespace FeedbackData
{
  public class FeedbackDataSource
  {
    private static CloudStorageAccount storageAccount;
    private FeedbackServiceContext context;

    static FeedbackDataSource()
    {
        // Wczytywanie informacji o połączeniu z pliku konfiguracyjnego.
      storageAccount = CloudStorageAccount.FromConfigurationSetting(
        "StorageCnnStr");

      // Tworzenie tabeli opartej na klasie FeedbackServiceContext.
      CloudTableClient.CreateTablesFromModel(
          typeof(FeedbackServiceContext), 
          storageAccount.TableEndpoint.AbsoluteUri, 
          storageAccount.Credentials);
    }

    public FeedbackDataSource()
    {
      this.context = new FeedbackServiceContext(
        storageAccount.TableEndpoint.AbsoluteUri, storageAccount.Credentials);
      
      this.context.RetryPolicy = RetryPolicies.Retry(3, TimeSpan.FromSeconds(3));
    }

    public IEnumerable<Feedback> Select(string partitionMmYyyy)
    {
        // Pobieranie informacji zwrotnych z danego miesiąca i roku. 
      var results = from f in this.context.Feedback
                    where f.PartitionKey == "UnleashedFeedback" + partitionMmYyyy
                    select f;
      return results;
    }

    public void AddFeedback(Feedback item)
    {
        // Dodawanie wiersza z informacjami zwrotnymi do kontekstu usługi (do danych).
      this.context.AddObject("Feedback", item);

      // Utrwalanie zmian w tabeli.
      this.context.SaveChanges();
    }

    public Feedback GetFeedback(string partitionKey, string rowKey)
    {
        // Pobieranie z tabeli pojedynczego elementu z informacjami zwrotnymi.
      var results = from f in this.context.Feedback
                    where f.PartitionKey == "UnleashedFeedback" + 
                      partitionKey && f.RowKey == rowKey
                    select f;

      Feedback feedbackItem = results.FirstOrDefault<Feedback>();
      return feedbackItem;
    }

    public void SetReplySent(string partitionKey, string rowKey)
    {
        // Pobieranie elementu z informacjami zwrotnymi.
      Feedback f = this.GetFeedback(partitionKey, rowKey);

      // Oznaczanie odpowiedzi jako wysłanej.
      f.ReplySent = true;

      // Aktualizowanie obiektu i zapisywanie go w tabeli.
      this.context.UpdateObject(f);
      this.context.SaveChanges();
    }

  }
}