﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.WindowsAzure.StorageClient;


namespace FeedbackData
{
  public class Feedback : TableServiceEntity
  {
      // Definiowanie właściwości klasy Feedback.
    public string Name { get; set; }
    public string Email { get; set; }
    public string FeedbackMessage { get; set; }
    public bool RequestReply { get; set; }
    public bool ReplySent { get; set; }

    public Feedback()
    {
        // Definiowanie klucza partycji, aby umożliwić 
        // podział danych między węzły.
        PartitionKey = "UnleashedFeedback" + 
        DateTime.UtcNow.ToString("MMyyyy");

        // Tworzenie klucza wiersza do sortowania rekordów od najnowszego do najstarszego.
        // Należy dodać identyfikator GUID, aby zapewnić niepowtarzalność klucza.
        RowKey = string.Format("{0:10}_{1}", 
        DateTime.MaxValue.Ticks - DateTime.Now.Ticks, 
        Guid.NewGuid());
    }

  }
}
