﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Effects;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace WpfImageViewer
{
    /// <summary>
    /// Kod interakcji z oknem MainWindow.xaml.
    /// </summary>
    public partial class MainWindow : Window
    {
        #region Pola prywatne

        private DirectoryImageList _imgList;
        private string _path = 
            Environment.GetFolderPath(
            Environment.SpecialFolder.MyPictures);

        #endregion

        #region Konstruktor

        public MainWindow()
        {
            InitializeComponent();
            ResetList();
            this.DataContext = _imgList.Images;
        }

        #endregion

        #region Metody obsługi zdarzeń i delegaty

        private void FolderOpenMenuItem_Click
            (object sender, RoutedEventArgs e)
        {
            SetPath();
        }

        private void listBox1_SelectionChanged
            (object sender, SelectionChangedEventArgs e)
        {
            this.image1.Source = (BitmapSource)((sender as ListBox).SelectedItem);
            this.image1.Effect = null;
        }

        private void buttonBandW_Click
            (object sender, RoutedEventArgs e)
        {
            BitmapSource img = (BitmapSource)image1.Source;
            image1.Source = 
                new FormatConvertedBitmap
                    (img, PixelFormats.Gray16, 
                    BitmapPalettes.Gray256, 1.0);
        }

        private void buttonBlur_Click
            (object sender, RoutedEventArgs e)
        {
            if (image1.Effect != null)
            {
                // Jeśli zastosowano już efekt rozmycia, należy go usunąć.
                image1.Effect = null;
            }
            else
            {
                // W przeciwnym razie należy dodać efekt rozmycia.
                image1.Effect = new BlurEffect();
            }
        }

        private void buttonRotate_Click
            (object sender, RoutedEventArgs e)
        {
            CachedBitmap cache = 
                new CachedBitmap((BitmapSource)image1.Source, 
                    BitmapCreateOptions.None, 
                    BitmapCacheOption.OnLoad);
            image1.Source = 
                new TransformedBitmap(cache, 
                    new RotateTransform(90));

        }

        private void buttonFlip_Click
            (object sender, RoutedEventArgs e)
        {
            CachedBitmap cache = 
                new CachedBitmap((BitmapSource)image1.Source, 
                    BitmapCreateOptions.None, 
                    BitmapCacheOption.OnLoad);
            ScaleTransform scale = 
                new ScaleTransform(-1, -1, image1.Source.Width / 2, 
                    image1.Source.Height / 2);
            image1.Source = 
                new TransformedBitmap(cache, scale);
        }


        #endregion

        #region Implementacja

        private void SetPath()
        {
            System.Windows.Forms.FolderBrowserDialog dlg = 
                new System.Windows.Forms.FolderBrowserDialog();
            dlg.ShowDialog();
            _path = dlg.SelectedPath;
            ResetList();
        }

        private void ResetList()
        {
            if (IsValidPath(_path))
            {
                _imgList = new DirectoryImageList(_path);
            }

            this.DataContext = _imgList.Images;

        }

        private bool IsValidPath(string path)
        {

            try
            {
                string folder = 
                    System.IO.Path.GetFullPath(path);
                return true;
            }
            catch
            {
                return false;
            }
        }

        #endregion


    }
}
