﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Media.Imaging;

namespace WpfImageViewer
{
    public class DirectoryImageList
    {
        private string _path;
        private List<BitmapSource> _images = new List<BitmapSource>();

        public DirectoryImageList(string path)
        {
            _path = path;
            LoadImages();

        }

        public List<BitmapSource> Images
        {
            get { return _images; }
            set { _images = value; }
        }

        public string Path
        {
            get { return _path; }
            set
            {
                _path = value;
                LoadImages();
            }
        }

        private void LoadImages()
        {
            _images.Clear();
            BitmapImage img;

            foreach (string file in Directory.GetFiles(_path))
            {
                try
                {
                    img = new BitmapImage(new Uri(file));

                    _images.Add(img);
                }
                catch
                {
                    // Pusty blok catch. Możnba zignorować pliki, których 
                    // nie można wczytać jako rysunku.
                }
            }
        }

    }

}
