﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace CodeMetricAdornment
{
    /// <summary>
    /// Interaction logic for CodeMetricDisplayControl.xaml
    /// </summary>
    public partial class CodeMetricDisplayControl : UserControl
    {
        private int _loc = 0;   // total lines of code
        private int _whitespace = 0; // whitespace (empty) lines
        private int _comments = 0; // total lines that are comments

        public int LinesOfCode
        {
            get { return _loc; }
            set { _loc = value; Refresh(); }
        }


        public int CommentLines
        {
            get { return _comments; }
            set { _comments = value; Refresh(); }
        }


        public int WhitespaceLines
        {
            get { return _whitespace; }
            set { _whitespace = value; Refresh(); }
        }

        public CodeMetricDisplayControl()
        {
            InitializeComponent();
        }

        private void Refresh()
        {
            this.TextBlockComments.Text = _comments.ToString();
            this.TextBlockLOC.Text = _loc.ToString();
            this.TextBlockWhitespace.Text = _whitespace.ToString();
        }

    }
}
