﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

using Microsoft.Win32;

namespace ColorSelectorAddIn
{
    [GuidAttribute("9B1C7498-3F07-4443-A464-B704B443532B")]
    public partial class PaletteControl : UserControl
    {
        #region pola

        private string _code = "";
        private bool _generateVB = false;

        #endregion 

        #region Konstruktory

        public PaletteControl()
        {
            InitializeComponent();

            this.pictureBoxPalette.MouseMove += new MouseEventHandler(pictureBoxPalette_MouseMove);

            pictureBoxPalette.Cursor = System.Windows.Forms.Cursors.Cross;
        }

        #endregion 

        #region Wlasciwosci

        public string Code
        {
            get { return _code; }
            set { _code = value; }
        }

        public bool GenerateVB
        {
            get { return _generateVB; }
            set { _generateVB = value; }
        }

        #endregion

        #region Zdarzenia i metody ich obslugi

        void pictureBoxPalette_MouseMove(object sender, MouseEventArgs e)
        {
            try
            {
                // Pobiera kolor odpowiadający bieżącej pozycji kursora.
                Color color = GetPointColor(e.X, e.Y);

                // Aktualizuje na podstawie wybranego koloru etykiety 
                // z wartościami składowych RGB i drugie pole z rysunkiem.
                DisplayColor(color);

                // Generuje kod struktury Color w języku
                // Visual Basic lub C#.
                SetCode(color, _generateVB);
            }

            catch
            {

            }

        }

        public event EventHandler ColorSelected;

        protected virtual void OnColorSelected(EventArgs e)
        {
            if (ColorSelected != null)
                ColorSelected(this, e);
        }

        private void pictureBoxPalette_Click(object sender, EventArgs e)
        {
            OnColorSelected(new EventArgs());
        }

        #endregion

        #region Wewnetrzne procedury

        /// <summary>
        /// Zwraca strukturę Color reprezentującą kolor
        /// piksela o określonych współrzędnych x i y.
        /// </summary>
        /// <param name="x"></param>
        /// <param name="y"></param>
        /// <returns>Struktura Color</returns>
        private Color GetPointColor(int x, int y)
        {
            // Pobieranie bitmapy z pola z rysunkiem palety.
            Bitmap bmp = (Bitmap)pictureBoxPalette.Image;

            // Używa metody GetPixel do pobrania struktury
            // Color odpowiadającej bieżącej pozycji kursora.
            Color color = bmp.GetPixel(x, y);

            // Zwraca strukturę Color.
            return color;
        }

        /// <summary>
        /// Wyświetla wartości składowych RGB dla danego koloru. Ponadto
        /// ustawia kolor tła drugiej kontrolki PictureBox.
        /// </summary>
        /// <param name="color">Wyświetlany kolor</param>
        private void DisplayColor(Color color)
        {
            try
            {
                // Pobiera wartości składowych RGB ze 
                // struktury Color.
                string R = color.R.ToString();
                string G = color.G.ToString();
                string B = color.B.ToString();

                // Wyświetla bieżący kolor
                // w drugiej kontrolce PictureBox.
                this.pictureBoxColor.BackColor = color;

                // Wyświetla wartości składowych RGB
                // na etykietach.
                this.labelRValue.Text = R;
                this.labelGValue.Text = G;
                this.labelBValue.Text = B;
            }

            catch
            {
                this.labelRValue.Text = "brak";
                this.labelGValue.Text = "brak";
                this.labelBValue.Text = "brak";
            }

        }

        /// <summary>
        /// Generuje łańcuch znaków reprezentujący kod w języku C# lub Visual Basic 
        /// potrzebny to utworzenia egzemplarza struktury Color odpowiadającej przekazanej
        /// strukturze Color. Ten łańcuch znaków zostaje przypisany do pola _code
        /// kontrolki użytkownika.
        /// </summary>
        /// <param name="color">Kolor reprezentowany w kodzie.</param>
        /// <param name="isVB">Flaga logiczna określająca używany język:
        /// false oznacza język C#, a true — język Visual Basic</param>
        private void SetCode(Color color, bool isVB)
        {
            // Wczytuje ustawienia dodatku z rejestru.
            SetPropFromReg();

            string code = "";

            if (isVB)
            {
                code = "Dim color As Color = ";
            }
            else
            {
                code = "Color color = ";
            }

            code = code + @"Color.FromArgb(" + color.R.ToString() + ", " +
                color.G.ToString() + ", " +
                color.B.ToString() + ");";

           _code = code;
            this.labelCode.Text = _code;

        }
        /// <summary>
        /// Wczytuje wartości z rejestru i w odpowiedni sposób ustawia
        /// pole określające używany język.
        /// </summary>
        private void SetPropFromReg()
        {
            try
            {
                RegistryKey regKey =
                  Registry.CurrentUser.OpenSubKey(@"Software\Contoso\Addins\ColorPalette");
                string codeVal = (string)regKey.GetValue("Language", "CSharp");

                if (codeVal == "CSharp")
                {
                    _generateVB = false;
                }
                else
                {
                    _generateVB = true;
                }
            }

            catch
            {
                _generateVB = false;
            }
        }



        #endregion

    }
}
