﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace AplikacjaZBazaDanych
{
    public partial class Form2 : Form
    {
        AdresyDataContext bazaDanychAdresy = new AdresyDataContext();

        public Form2()
        {
            InitializeComponent();

            //dataGridView1.DataSource = bazaDanychAdresy.Osobas;
            /*
            dataGridView1.DataSource = from osoba in bazaDanychAdresy.Osobas
                                       where osoba.Wiek >= 18
                                       orderby osoba.Imię
                                       select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };
            */
            /*
            dataGridView1.DataSource = from osoba in bazaDanychAdresy.Osobas
                                       where osoba.Wiek >= 18
                                       orderby osoba.Imię
                                       select osoba;
            */

            dataGridView1.DataSource = bazaDanychAdresy.OsobyPelnoletnies;

            comboBox1.DataSource = dataGridView1.DataSource;
            comboBox1.ValueMember = "Id";
            comboBox1.DisplayMember = "Email";

            if (textBox1.DataBindings.Count == 0) textBox1.DataBindings.Add("Text", bazaDanychAdresy.Osobas, "Email");
            if (numericUpDown1.DataBindings.Count == 0) numericUpDown1.DataBindings.Add("Value", bazaDanychAdresy.Osobas, "Wiek");
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            label1.Text = comboBox1.SelectedValue.ToString();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            var listaOsob = bazaDanychAdresy.Osobas;
            var rozmowy = bazaDanychAdresy.Rozmowies;

            IEnumerable<string> listaDlugichRozmow =
                from osoba in listaOsob
                join rozmowa in rozmowy on osoba.Id equals rozmowa.Id
                where rozmowa.CzasTrwania > 10
                select osoba.Imię + " " + osoba.Nazwisko + ", " + rozmowa.Data.ToString() +
                    " (" + rozmowa.CzasTrwania + ")";

            string s = "Lista rozmów trwających dłużej niż 10 sekund:\n";
            foreach (string opis in listaDlugichRozmow) s += opis + "\n";
            MessageBox.Show(s);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            var listaOsob = bazaDanychAdresy.Osobas;
            var rozmowy = bazaDanychAdresy.Rozmowies;

            var listaDlugichRozmow = from rozmowa in rozmowy
                                     where rozmowa.CzasTrwania > 10
                                     select rozmowa.Osoba.Imię + " " +
                                            rozmowa.Osoba.Nazwisko + ", " +
                                            rozmowa.Data.ToString() +
                                            " (" + rozmowa.CzasTrwania + ")";

            string s = "Lista rozmów trwających dłużej niż 10 sekund:\n";
            foreach (string opis in listaDlugichRozmow) s += opis + "\n";
            MessageBox.Show(s);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            IEnumerable<ListaOsobPelnoletnichResult> listaOsobPelnoletnich =
                                  bazaDanychAdresy.ListaOsobPelnoletnich();

            string s = "Lista osób pełnoletnich (procedura składowana):\n";
            foreach (var osoba in listaOsobPelnoletnich)
                s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
        }

        private void button4_Click(object sender, EventArgs e)
        {
            bazaDanychAdresy.AktualizujWiek();
        }

        private void button5_Click(object sender, EventArgs e)
        {
            try
            {
                bazaDanychAdresy.TwórzNowąTabelę();
                MessageBox.Show("Tabela 'Faktury' została utworzona");
            }
            catch(Exception exc)
            {
                MessageBox.Show("Błąd podczas tworzenia tabeli 'Faktury': " + exc.Message);
            }
        }
    }
}
