﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Data.Linq.Mapping;
using System.Data.Linq;

namespace AplikacjaZBazaDanych
{
    public partial class Form1 : Form
    {
        [Table(Name = "Osoby")]
        public class Osoba
        {
            [Column(Name = "Id", IsPrimaryKey = true)]
            public int Id;
            [Column(CanBeNull = false)]
            public string Imię;
            [Column(CanBeNull = false)]
            public string Nazwisko;
            [Column(CanBeNull = false)]
            public string Email;
            [Column(CanBeNull = true)]
            public int? NumerTelefonu;
            [Column(CanBeNull = false)]
            public int Wiek;
        }

        static string connectionString = @"Data Source=(LocalDB)\v11.0;AttachDbFilename=|DataDirectory|\Adresy.mdf;Integrated Security=True";
        static DataContext bazaDanychAdresy = new DataContext(connectionString);
        static Table<Osoba> listaOsob = bazaDanychAdresy.GetTable<Osoba>();

        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //pobieranie kolekcji
            var listaOsobPelnoletnich = from osoba in listaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Nazwisko
                                        select osoba;

            //wyświetlanie pobranej kolekcji
            string s = "Lista osób pełnoletnich:\n";
            foreach (Osoba osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + 
                osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //pobieranie kolekcji
            var listaOsobDoZmianyWieku = from osoba in listaOsob
                                         where (osoba.Wiek < 18 || !osoba.Imię.EndsWith("a"))
                                         select osoba;

            //wyświetlanie pobranej kolekcji
            string s = " Lista osób niebędących pełnoletnimi kobietami:\n";
            foreach (Osoba osoba in listaOsobDoZmianyWieku) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);

            //modyfikowanie kolekcji
            foreach (Osoba osoba in listaOsobDoZmianyWieku) osoba.Wiek++;

            //wyświetlanie pełnej listy osób kolekcji po zmianie
            s = "Lista wszystkich osób:\n";
            foreach (Osoba osoba in listaOsob) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);

            //zapisywanie zmian
            bazaDanychAdresy.SubmitChanges();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            //dodawanie osoby do tabeli
            int noweId = listaOsob.Max(osoba => osoba.Id) + 1;
            MessageBox.Show("Nowe Id: " + noweId);
            Osoba noworodek = new Osoba { Id = noweId, Imię = "Nela", Nazwisko = "Boderska", Email = "nb@bocian.pl", NumerTelefonu = null, Wiek = 0 };
            listaOsob.InsertOnSubmit(noworodek);

            //zapisywanie zmian
            bazaDanychAdresy.SubmitChanges(); //dodawany jest także nowy rekord

            //wyświetlanie tabeli
            string s = "Lista osób:\n";
            foreach (Osoba osoba in listaOsob) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
        }

        private void button4_Click(object sender, EventArgs e)
        {
            //wybieranie elementów do usunięcia i ich oznaczanie
            IEnumerable<Osoba> doSkasowania = from osoba in listaOsob
                                              where osoba.Imię == "Nela"
                                              select osoba;
            listaOsob.DeleteAllOnSubmit(doSkasowania);

            //zapisywanie zmian
            bazaDanychAdresy.SubmitChanges();

            //wyświetlanie tabeli
            string s = "Lista osób:\n";
            foreach (Osoba osoba in listaOsob) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
        }

        private void button5_Click(object sender, EventArgs e)
        {
            var osobyPelnoletnie = from o in listaOsob
                                   where o.Wiek >= 18
                                   orderby o.Nazwisko
                                   select new { o.Id, o.Imię, o.Nazwisko, o.Email, o.NumerTelefonu, o.Wiek };                                   
            dataGridView1.DataSource = osobyPelnoletnie;
        }
    }
}
