﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LinqToObjects
{
    class Osoba
    {
        public int Id;
        public string Imię, Nazwisko;
        public int NumerTelefonu;
        public int Wiek;
    }

    class Program
    {
        //źródło danych
        static List<Osoba> listaOsob = new List<Osoba> 
        { 
            new Osoba { Id = 1, Imię = "Jan", Nazwisko = "Kowalski", 
                        NumerTelefonu = 7272024, Wiek = 39 }, 
            new Osoba { Id = 2, Imię = "Andrzej", Nazwisko = "Kowalski", 
                        NumerTelefonu = 7272020, Wiek = 29 },
            new Osoba { Id = 3, Imię = "Maciej", Nazwisko = "Bartnicki", 
                        NumerTelefonu = 7272021, Wiek = 42 }, 
            new Osoba { Id = 4, Imię = "Witold", Nazwisko = "Mocarz", 
                        NumerTelefonu = 7272022, Wiek = 26 },
            new Osoba { Id = 5, Imię = "Adam", Nazwisko = "Kowalski", 
                        NumerTelefonu = 7272023, Wiek = 6 },
            new Osoba { Id = 6, Imię = "Ewa", Nazwisko = "Mocarz", 
                        NumerTelefonu = 7272025, Wiek = 11 }
        };

        static void Main(string[] args)
        {
            //Pobieranie danych (filtrowanie i sortowanie)
            var listaOsobPelnoletnich = from osoba in listaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Wiek
                                        select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };

            /*
            var listaOsobPelnoletnich = from osoba in listaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Wiek
                                        select osoba;
            List<Osoba> podlista = listaOsobPelnoletnich.ToList<Osoba>();
            */

            //Najprostsza prezentacja pobranych danych
            Console.WriteLine("Lista osób pełnoletnich:");
            foreach (var osoba in listaOsobPelnoletnich)
                Console.WriteLine(osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")");

            Console.WriteLine();

            //Analiza pobranych danych
            Console.WriteLine("Wiek najstarszej osoby: " +
                listaOsobPelnoletnich.Max(osoba => osoba.Wiek));
            Console.WriteLine("Średni wiek osób pełnoletnich: " +
               listaOsobPelnoletnich.Average(osoba => osoba.Wiek));
            Console.WriteLine("Suma lat osób pełnoletnich: " +
               listaOsobPelnoletnich.Sum(osoba => osoba.Wiek));

            Console.WriteLine();

            //Wybór elementu
            var najstarszaOsoba = listaOsobPelnoletnich.Single(
                osoba1 => (osoba1.Wiek == listaOsobPelnoletnich.Max(osoba => osoba.Wiek)));
            Console.WriteLine("Najstarsza osoba: " + najstarszaOsoba.Imię + " " +
                najstarszaOsoba.Nazwisko + " (" + najstarszaOsoba.Wiek + ")");

            //Console.WriteLine();

            //Weryfikowanie danych
            bool czyWszystkiePełnoletnie = listaOsobPelnoletnich.All(osoba => (osoba.Wiek > 18));
            bool czyZawieraPelnoletnią = listaOsob.Any(osoba => (osoba.Wiek > 18));

            Console.WriteLine();

            //Prezentacja w grupach
            var grupyOsobOTymSamymNazwisku = from osoba in listaOsob
                                             group osoba by osoba.Nazwisko into grupa
                                             select grupa;
            Console.WriteLine("Lista osób pogrupowanych nazwiskami:");
            foreach (var grupa in grupyOsobOTymSamymNazwisku)
            {
                Console.WriteLine("Grupa osób o nazwisku " + grupa.Key);
                foreach (Osoba osoba in grupa) Console.WriteLine(osoba.Imię + " " + osoba.Nazwisko);
                Console.WriteLine();
            }

            //Console.WriteLine();

            //Łączenie zbiorów danych
            /*
            var listaOsobPelnoletnich = from osoba in listaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Wiek
                                        select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };
            */
            var listaKobiet = from osoba in listaOsob
                              where osoba.Imię.EndsWith("a")
                              select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };

            //var listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich.Concat(listaKobiet);
            //var listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich.Concat(listaKobiet).Distinct();
            var listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich.Union(listaKobiet);
            var listaKobietPelnoletnich = listaOsobPelnoletnich.Intersect(listaKobiet);
            var listaPelnoletnichNiekobiet = listaOsobPelnoletnich.Except(listaKobiet);

            //Console.WriteLine();

            //Łączenie danych z różnych źródeł w zapytaniu LINQ — operator join
            var listaTelefonów = from osoba in listaOsob
                                 select new { osoba.Id, osoba.NumerTelefonu };
            var listaPersonaliów = from osoba in listaOsob
                                   select new { osoba.Id, osoba.Imię, osoba.Nazwisko };

            var listaPersonaliówZTelefonami = from telefon in listaTelefonów
                                              join personalia in listaPersonaliów
                                              on telefon.Id equals personalia.Id
                                              select new
                                              {
                                                  telefon.Id,
                                                  personalia.Imię,
                                                  personalia.Nazwisko,
                                                  telefon.NumerTelefonu
                                              };

            Console.WriteLine();

            //Możliwość modyfikacji danych źródła
            var nowaListaOsobPelnoletnich = from osoba in listaOsob
                                            where osoba.Wiek >= 18
                                            orderby osoba.Wiek
                                            select osoba;

            var _nowaListaOsobPelnoletnich = from osoba in listaOsob
                                            where osoba.Wiek >= 18
                                            orderby osoba.Wiek
                                            select new Osoba
                                            {
                                                Id = osoba.Id,
                                                Imię = osoba.Imię,
                                                Nazwisko = osoba.Nazwisko,
                                                NumerTelefonu = osoba.NumerTelefonu,
                                                Wiek = osoba.Wiek
                                            };

            Console.WriteLine("Lista przed zmianą:");
            foreach (var osoba in nowaListaOsobPelnoletnich)
                Console.WriteLine(osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")");
            
            Osoba pierwszyNaLiscie = nowaListaOsobPelnoletnich.First<Osoba>();
            pierwszyNaLiscie.Imię = "Karol";
            pierwszyNaLiscie.Nazwisko = "Bartnicki";
            pierwszyNaLiscie.Wiek = 31;

            Console.WriteLine("\nLista po zmianie:");
            foreach (var osoba in nowaListaOsobPelnoletnich)
                Console.WriteLine(osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")");

        }
    }
}
