﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ZaawansowaneProgramowanieObiektowe
{
    class Program
    {
        #region Osoba, Adres, OsobaZameldowana
        class Osoba
        {
            public string Imię;
            public string Nazwisko;
            public int Wiek;

            public override string ToString()
            {
                return Imię + " " + Nazwisko + " (" + Wiek + ")";
            }

            protected string Personalia
            {
                get
                {
                    return Imię + " " + Nazwisko;
                }
            }
        }

        class Adres
        {
            public string Miasto;
            public string Ulica;
            public int NumerDomu;
            public int? NumerMieszkania;

            public override string ToString()
            {
                return Miasto + ", ul. " + Ulica + " " + NumerDomu + (NumerMieszkania.HasValue ? ("/" + NumerMieszkania) : "");
            }
        }

        interface IPosiadaTelefonStacjonarny
        {
            int? NumerTelefonu { get; set; }
        }

        class OsobaZameldowana : Osoba, IPosiadaTelefonStacjonarny
        {
            public Adres AdresZameldowania;

            public override string ToString()
            //public new string ToString()
            {                
                return base.ToString() + "; " + AdresZameldowania.ToString();
            }

            private int? numerTelefonu;

            public int? NumerTelefonu
            {
                get
                {
                    return numerTelefonu;
                }
                set
                {
                    numerTelefonu = value;
                }
            }

            public bool CzyPosiadaTelefonStacjonarny
            {
                get
                {
                    return numerTelefonu.HasValue;
                }
            }
        }

        static void Main_OsobaZameldowana(string[] args)
        {
            OsobaZameldowana jk = new OsobaZameldowana()
            {
                Imię = "Jan",
                Nazwisko = "Kowalski",
                Wiek = 42,
                AdresZameldowania = new Adres
                {
                    Miasto = "Toruń",
                    Ulica = "Grudziadzka",
                    NumerDomu = 5,
                    NumerMieszkania = null
                }
            };

            Console.WriteLine(jk.ToString());

            Console.WriteLine();

            Osoba jkb = jk;
            Console.WriteLine(jkb.ToString());

            Console.WriteLine();

            List<IPosiadaTelefonStacjonarny> listaTelefonów = new List<IPosiadaTelefonStacjonarny>();
            listaTelefonów.Add(new OsobaZameldowana() { NumerTelefonu = 123456789 });
            listaTelefonów.Add(new OsobaZameldowana() { NumerTelefonu = 987654321 });
            foreach (IPosiadaTelefonStacjonarny telefon in listaTelefonów)
                //Console.WriteLine("Numer telefonu: " + telefon.NumerTelefonu);
                WyświetlNumerTelefonu(telefon);
        }

        static void WyświetlNumerTelefonu(IPosiadaTelefonStacjonarny telefon)
        {
            Console.WriteLine("Numer telefonu: " + telefon.NumerTelefonu);
        }
        #endregion

        #region Figury
        abstract class Figura 
        {
            public abstract int IleWierzchołków();
            //public abstract int LiczbaWierzchołków { get; }
            public virtual int LiczbaWierzchołków 
            { 
                get
                {
                    return IleWierzchołków();
                }
            }

            public Figura()
            {
                Console.WriteLine("Konstruktor klasy Figura");
            }

            public Figura(string argument)
            {
                Console.WriteLine("Konstruktor klasy Figura, komunikat: " + argument);
            }
        }        

        class Okrąg : Figura
        {
            public override int IleWierzchołków()
            {
                return 0;
            }
        }

        class Trójkąt : Figura
        {
            public override int IleWierzchołków()
            {
                return 3;
            }

            public Trójkąt()
            {
                Console.WriteLine("Konstruktor klasy Trójkąt");
            }

            public Trójkąt(string argument)
                : base(argument)
            {
                Console.WriteLine("Konstruktor klasy Trójkąt, komunikat: " + argument);
            }
        }

        class Prostokąt : Figura
        {
            public override int IleWierzchołków()
            {
                return 4;
            }
        }

        class Kwadrat : Prostokąt { }
        
        static void Main_Figura(string[] args)
        {
            //Figura f = new Figura(); //błąd kompilatora
            Figura f = new Kwadrat();
            Kwadrat k = new Kwadrat();

            List<Figura> figury = new List<Figura>();
            figury.Add(new Okrąg());
            figury.Add(new Trójkąt());
            figury.Add(new Prostokąt());
            figury.Add(new Kwadrat());
            foreach (Figura figura in figury)
                //Console.WriteLine("Figura " + figura.GetType().Name + " ma " + figura.IleWierzchołków() + " wierzchołków.");
                WyświetlIlośćWierzchołków(figura);

            Console.WriteLine();

            new Trójkąt();
            new Trójkąt("jestem trójkątem");
        }

        static void WyświetlIlośćWierzchołków(Figura figura)
        {
            Console.WriteLine("Liczba wierzchołków figury: " + figura.IleWierzchołków());
        }
        #endregion

        static void Main(string[] args)
        {
            Main_OsobaZameldowana(args);
            Console.WriteLine();
            Main_Figura(args);
        }
    }
}
