﻿#if DEBUG
#warning Pamiętaj, aby przed publikacją skompilować w wersji "Release"
#endif

#if DEBUG
#warning Kompilacja "debug"
#else
#warning Kompilacja "release"
#endif

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Runtime.CompilerServices; //Caller information

namespace JezykCS
{
    [Nadzór("J. Matulewski", "nieprzydzielony", CzySprawdzone = false)]
    class Program
    {
        static void Main(string[] args)
        {
            #if DEBUG
                Console.Title = "Kompilacja \"debug\"";
            #endif

            PodstawoweTypyDanych();
            String_StringBuilder();
            TypWyliczeniowy();
            LeniweInicjowanieZmiennych();
            Metody();
            WyrazeniaLambda();
            TypyReferencyjneIWartosciowe();
            TypNullable();
            Pudelkowanie();
            TypDynamiczny();
            SterowaniePrzeplywem();
            Wyjatki();
            Tablice();
            Listy();
            Slownik();
            KolejkaStos();
            Params();
            Yield();
            CallerInformation();
            WyświetlInformacjeONadzorzeKlasy(typeof(Program));

            Console.WriteLine("\nOK.\n");
        }

        static void PodstawoweTypyDanych()
        {
            Console.WriteLine("Podstawowe typy danych:\n");

            int i = 1;
            long l = 1L;
            string s = "Helion";
            float f = 1.0f;
            double d = 1.0;

            Console.WriteLine("i=" + i.ToString());
            Console.WriteLine("l=" + l.ToString());
            Console.WriteLine("s=" + s);
            Console.WriteLine("f=" + f.ToString());
            Console.WriteLine("d=" + d.ToString());

            Console.WriteLine();

            var vi = 5;
            var vl = 5L;
            var vs = "Helion";
            var vf = 1.0f;
            var vd = 1.0;

            Console.WriteLine("vi=" + vi.ToString() + ", typ: " + vi.GetType().FullName);
            Console.WriteLine("vl=" + vl.ToString() + ", typ: " + vl.GetType().FullName);
            Console.WriteLine("vs=" + vs + ", typ: " + vs.GetType().FullName);
            Console.WriteLine("vf=" + vf.ToString() + ", typ: " + vf.GetType().FullName);
            Console.WriteLine("vd=" + vd.ToString() + ", typ: " + vd.GetType().FullName);

            Console.WriteLine();
            
            byte x1 = 74, z1 = (byte)(~x1); Console.WriteLine("" + z1);
            byte x2 = 74, y2 = 15, z2 = (byte)(x2 & y2); Console.WriteLine("" + z2);

            Console.WriteLine();

            Object o = new DivideByZeroException();            
            if (o is DivideByZeroException) Console.WriteLine("Obiekt jest wyjątkiem dzielenia przez zero");
            else Console.WriteLine("Obiekt nie jest wyjątkiem dzielenia przez zero");
            if (o is Exception) Console.WriteLine("Obiekt jest wyjątkiem ");
            else Console.WriteLine("Obiekt nie jest wyjątkiem");
            Console.WriteLine(o.GetType().FullName);

            //DivideByZeroException e = null;
            //if (o is DivideByZeroException) exc = (DivideByZeroException)o;
            DivideByZeroException exc = o as DivideByZeroException;

            Console.WriteLine("\n-----------------\n");
        }

        static void String_StringBuilder()
        {
            Console.WriteLine("String vs StringBuilder:\n");

            //string
            string s = "abc---";
            s += "xyz";
            s = s.Replace("---", " ijk ");
            Console.WriteLine(s);

            //StringBuilder
            System.Text.StringBuilder sb = new System.Text.StringBuilder("abc---");
            sb.Append("xyz");
            sb.Replace("---", " ijk ");
            Console.WriteLine(sb.ToString());

            Console.WriteLine("\n-----------------\n");
        }

        public enum DniTygodnia : byte { niedziela = 1, poniedzialek, wtorek, sroda, czwartek, piatek, sobota };

        static void TypWyliczeniowy()
        {
            Console.WriteLine("Typ wyliczeniowy:\n");

            DniTygodnia pn = DniTygodnia.poniedzialek;
            //byte nrDniaTygodnia=(byte)DniTygodnia.poniedzialek;
            byte nrDniaTygodnia = (byte)pn;
            Console.WriteLine(pn.ToString() + " - " + nrDniaTygodnia);

            Console.WriteLine("\n-----------------\n");
        }
        static void LeniweInicjowanieZmiennych()
        {
            Console.WriteLine("Leniwe inicjowanie zmiennych:\n");

            Lazy<int> li = new Lazy<int>(() => 1); //deklaracja zmiennej i wskazanie funkcji
            Console.WriteLine(li.IsValueCreated.ToString()); //jeszcze niezainicjowana
            Console.WriteLine("Odwołanie do zmiennej, li=" + li.Value); //leniwa inicjacja
            Console.WriteLine(li.IsValueCreated.ToString()); //już zainicjowana

            Console.WriteLine("\n-----------------\n");
        }

        static void Metoda()
        {
            Console.WriteLine("Hello World!");
        }

        static void Metoda(string tekst)
        {
            Console.WriteLine(tekst);
        }

        static void Metoda(string tekst, ConsoleColor kolor = ConsoleColor.White)
        {
            ConsoleColor bieżącyKolor = Console.ForegroundColor;
            Console.ForegroundColor = kolor;
            Console.WriteLine(tekst);
            Console.ForegroundColor = bieżącyKolor;
        }

        static private int Kwadrat(int arg)
        {
            return arg * arg;
        }

        delegate int Delegacja(int arg);
        static event Delegacja ReferencjaKwadrat;

        static private void zakresDouble(double min, double max)
        {
            min = double.MinValue;
            max = double.MaxValue;
            Console.WriteLine("Liczby double mogą należeć do przedziału (" + min + "," + max + ")");
        }

        static private int InnaMetoda(int arg)
        {
            Console.WriteLine("InnaMetoda: arg="+arg.ToString());
            return arg;
        }

        static private int ReferencjaDoTrzeciejMetody(int arg)
        {
            Console.WriteLine("ReferencjaDoTrzeciejMetody: arg=" + arg.ToString());
            return arg;
        }

        static private void obiekt_MetodaZakonczona(object sender, DateTime czasZakonczeniaMetody)
        {
            Console.WriteLine("Zakonczona metoda obiektu typu " + sender.GetType().Name + " (czas: " + czasZakonczeniaMetody.ToString() + ")");
        }

        static void Metody()
        {
            Console.WriteLine("Metody:\n");

            Metoda();
            Metoda("Witaj, świecie!");
            Metoda("Witaj, świecie!", ConsoleColor.Green);
            Metoda(kolor: ConsoleColor.Green, tekst: "Witaj, świecie!");
            Metoda(tekst: "Witaj, świecie!", kolor: ConsoleColor.Green);

            Console.WriteLine();

            int wynik = Kwadrat(2);
            Console.WriteLine(wynik.ToString());

            Console.WriteLine();

            double min = 0, max = 0;
            zakresDouble(min, max);
            Console.WriteLine("Liczby double mogą należeć do przedziału (" + min + "," + max + ")");

            Console.WriteLine();

            Delegacja ReferencjaDoMetodyKwadrat = Kwadrat;
            int i = Kwadrat(2);
            int j = ReferencjaDoMetodyKwadrat(2);
            Console.WriteLine("i=" + i + ", j=" + j);

            Console.WriteLine();

            Action<double, double> Akcja = zakresDouble;
            Func<int, int> Funkcja = Kwadrat;

            Console.WriteLine();

            //Delegacja ReferencjaDoMetodyKwadrat = Kwadrat;
            Delegacja ReferencjaDoInnejMetody = InnaMetoda;
            Delegacja ReferencjaDoWieluMetod = ReferencjaDoMetodyKwadrat + ReferencjaDoInnejMetody;
            ReferencjaDoWieluMetod += ReferencjaDoTrzeciejMetody;
            int wynikOstatniejMetody = ReferencjaDoWieluMetod(2);

            Console.WriteLine();

            ReferencjaKwadrat += Kwadrat;
            int k = ReferencjaKwadrat(2);
            Console.WriteLine("k=" + k);

            Console.WriteLine();

            Klasa obiekt = new Klasa();
            //subskrypcja
            obiekt.DelegacjaMetodaZakonczona = obiekt_MetodaZakonczona;
            obiekt.ZdarzenieMetodaZakonczona += obiekt_MetodaZakonczona;
            //uruchomienie metody, ktora wywola metode zdarzeniowa
            obiekt.Metoda();

            /*
            obiekt.DelegacjaMetodaZakonczona(obiekt, DateTime.Now); //symulacja zdarzenia
            if (obiekt.DelegacjaMetodaZakonczona == null)
                Console.WriteLine("Delegacja nieprzypisana");

            //te instrukcje spowodują błąd kompilacji
            obiekt.ZdarzenieMetodaZakonczona(obiekt, DateTime.Now);
            if (obiekt.ZdarzenieMetodaZakonczona == null)
                Console.WriteLine("Zdarzenie nieprzypisane");
            */

            Console.WriteLine("\n-----------------\n");
        }

        //delegate int DInc(int n);
        //delegate bool DIsEqual(double x, double y);
        //delegate void DShow(int n);

        static void WyrazeniaLambda()
        {
            Console.WriteLine("Wyrażenia Lambda:\n");

            //DInc Inc = (int n) => n + 1;
            Func<int, int> Inc = (int n) => n + 1;
            Console.WriteLine("Inc(1)=" + Inc(1));

            //DIsEqual IsEqual = (x, y) => x == y;
            Func<double,double,bool> IsEqual = (x, y) => x == y;
            int a = 10;
            int b = 20;
            Console.WriteLine("Czy równe a=" + a + " i b=" + b + "? " + (IsEqual(a, b) ? "Tak" : "Nie"));
            Console.WriteLine("Czy równe a=" + a + " i a=" + a + "? " + (IsEqual(a, a) ? "Tak" : "Nie"));

            //DShow Show = n => { Console.WriteLine(n.ToString()); };
            Action<int> Show = n => { Console.WriteLine(n.ToString()); };
            Show(10);

            Console.WriteLine();

            string[] slowa = { "czereśnia", "jabłko", "borówka", "wiśnia", "jagoda" };
            int dlugoscNajkrotszego = slowa.Min(slowo => slowo.Length);
            //int dlugoscNajkrotszego = slowa.Min(delegate(string slowo) { return slowo.Length; });

            Console.WriteLine("\n-----------------\n");
        }

        static void TypyReferencyjneIWartosciowe()
        {
            Console.WriteLine("Typy referencyjne i wartościowe\n");

            DivideByZeroException d = new DivideByZeroException();

            //Int32 i1 = new Int32();
            //int i2 = new int();
            int i = 1;

            DivideByZeroException e = d;
            int j = i;

            Console.WriteLine("\n-----------------\n");
        }

        static void TypNullable()
        {
            Console.WriteLine("Typ Nullable:\n");

            Nullable<int> ni = 1;
            int i1;
            if (ni.HasValue)
            {
                i1 = ni.Value;
            }
            else
            {
                i1 = default(int);
            }
            int i2 = ni.GetValueOrDefault();
            Console.WriteLine("i1=" + i1 + ", i2=" + i2);

            Console.WriteLine("\n-----------------\n");
        }

        static void Pudelkowanie()
        {
            Console.WriteLine("Pudełkowanie:\n");

            int i = 1;
            object o = i;
            Console.WriteLine(o.GetType().ToString()); //zwraca System.Int32

            int j = (int)o;
            Console.WriteLine(j.ToString());

            Console.WriteLine("\n-----------------\n");
        }

        static dynamic obiekt = 1; //pole

        enum Typ { Int, Long, String, Float, Double, DivideByZeroException, Pole, InstancjaKlasy };

        dynamic Obiekt //właściwość
        {
            get
            {
                return zwrocObiekt();
            }
            set
            {
                obiekt = value;
            }
        }

        static dynamic zwrocObiekt(Typ ktoryTyp = Typ.Int) //wartość zwracana przez metodę
        {
            dynamic wartosc;
            switch (ktoryTyp)
            {
                case Typ.Int: wartosc = 5; break;
                case Typ.Long: wartosc = 5L; break;
                case Typ.String: wartosc = "Helion"; break;
                case Typ.Float: wartosc = 1.0f; break;
                case Typ.Double: wartosc = 1.0; break;
                case Typ.DivideByZeroException: wartosc = new DivideByZeroException(); break;
                case Typ.Pole: wartosc = obiekt; break;
                case Typ.InstancjaKlasy: wartosc = new Klasa(); break;
                default: wartosc = null; break;
            }
            return wartosc;
        }

        static void TypDynamiczny()
        {
            Console.WriteLine("Typ dynamiczny:\n");

            dynamic o; //nie działa IntelliSense
            o = 5; Console.WriteLine(o.ToString() + ", " + o.GetType().FullName);
            o = 5L; Console.WriteLine(o.ToString() + ", " + o.GetType().FullName);
            o = "Helion"; Console.WriteLine(o.ToString() + ", " + o.GetType().FullName);
            o = 1.0f; Console.WriteLine(o.ToString() + ", " + o.GetType().FullName);
            o = 1.0; Console.WriteLine(o.ToString() + ", " + o.GetType().FullName);

            Console.WriteLine();

            for (Typ typ = Typ.Int; typ <= Typ.InstancjaKlasy + 1; typ++)
            {
                Console.WriteLine("Typ: " + typ.ToString());
                try
                {
                    dynamic _o = zwrocObiekt(typ);
                    Console.WriteLine("Obiekt: " + _o.ToString() + ", typ: " + _o.GetType().FullName);
                    _o.Metoda(); //tu pojawi się wyjątek
                }
                catch (Exception exc)
                {
                    ConsoleColor bieżącyKolor = Console.ForegroundColor;
                    Console.ForegroundColor = ConsoleColor.Red;
                    Console.WriteLine("Błąd: " + exc.Message);
                    Console.ForegroundColor = bieżącyKolor;
                }
            }

            Console.WriteLine();

            //w starym stylu
            object _o2;
            _o2 = 5; Console.WriteLine(_o2.ToString() + ", " + _o2.GetType().FullName);
            _o2 = 5L; Console.WriteLine(_o2.ToString() + ", " + _o2.GetType().FullName);
            _o2 = "Helion"; Console.WriteLine(_o2.ToString() + ", " + _o2.GetType().FullName);
            _o2 = 1.0f; Console.WriteLine(_o2.ToString() + ", " + _o2.GetType().FullName);
            _o2 = 1.0; Console.WriteLine(_o2.ToString() + ", " + _o2.GetType().FullName);


            Console.WriteLine("\n-----------------\n");
        }

        static void SterowaniePrzeplywem()
        {
            Console.WriteLine("Sterowanie przepływem:\n");

            Random r = new Random();
            int n = r.Next(8);
            Console.WriteLine(n.ToString());

            //Składnia podstawowa if
            if (n < 6) Console.WriteLine("Wylosowana liczba jest mniejsza od 6.");

            //Składnia rozszerzona if..else
            if (n <= 4) Console.WriteLine("Wylosowana liczba jest mniejsza lub równa 4.");
            else Console.WriteLine("Wylosowana liczba jest większa od 4.");

            Console.WriteLine();

            /*Random*/ r = new Random();
            /*int*/ n = r.Next(9);
            string opis;
            switch (n)
            {
                case 1: opis = "niedziela"; break;
                case 2: opis = "poniedziałek"; break;
                case 3: opis = "wtorek"; break;
                case 4: opis = "środa"; break;
                case 5: opis = "czwartek"; break;
                case 6: opis = "piątek"; break;
                case 7: opis = "sobota"; break;
                case 8: goto default;
                default: opis = "błąd!"; break;
            }
            Console.WriteLine("Dzień tygodnia: " + n + ", " + opis);

            Console.WriteLine();

            /*Random*/ r = new Random();
            /*int*/ n = r.Next(8);
            //Zadanie komputera to odgadnąć 
            //liczbę z zakresu od 0 do 7
            int z; int licznik = 0;
            do
            {
                licznik++;
                z = r.Next(8);
            }
            while (n != z);
            Console.WriteLine("Komputer zgadł liczbę " + z + " po " + licznik + " próbach!");

            Console.WriteLine();

            for (int i = -1; i <= 1; i++)
                for (int j = -1; j <= 1; j++)
                {
                    if (i == 0 && j == 0) continue; //pomijamy przypadki, gdy obie zmienne równe są 0
                    Console.WriteLine("i=" + i + ", j=" + j);
                }

            Console.WriteLine("\n-----------------\n");
        }

        static long silnia(byte arg)
        {
            if (arg == 0) return 0;
            long wartosc = 1;
            for (byte i = 1; i <= arg; i++)
                wartosc *= i;
            return wartosc;
        }

        static long najwiekszyDzielnik(long arg)
        {
            long dzielnik = arg - 1;
            while (arg % dzielnik != 0)
                dzielnik--;
            return dzielnik;
        }

        static void Wyjatki()
        {
            Console.WriteLine("Wyjątki:\n");
            
            try
            {
                int x = 0;
                int y = 1 / x;
                Console.WriteLine("To polecenie nie zostanie wykonane!");
            }
            catch (DivideByZeroException exc)
            {
                Console.WriteLine("Dzielenie przez zero (" + exc.Message + ")");
                return;
            }
            catch (ArithmeticException exc)
            {
                Console.WriteLine("Błąd arytmetyki (" + exc.Message + ")");
                return;
            }
            catch (Exception exc)
            {
                Console.WriteLine("Wyjątek: " + exc.Message);
                return;
            }
            finally
            {
                Console.WriteLine("Kod wykonywany w każdym przypadku");

                Console.WriteLine("\n-----------------\n");
            }

            //throw new Exception("Komunikat opisujący błąd");

            Console.WriteLine("\n-----------------\n");
        }

        class PorownywaczWyjatkow : IComparer<Exception>
        {
            int IComparer<Exception>.Compare(Exception e1, Exception e2)
            {
                return e1.Message.CompareTo(e2.Message);
            }
        }

        static void Tablice()
        {
            Console.WriteLine("Tablice:\n");

            //int[] ti;
            //int[] ti = new int[3];
            int[] ti = new int[3] { 1, 2, 4 };

            //Exception[] te;
            //Exception[] te = new Exception[3];
            //Exception[] te = new Exception[3] { new Exception(), new Exception(), new Exception() };
            //Console.WriteLine("Komunikat: " + te[0].Message);

            Exception[] te = new Exception[3];
            for (int i = 0; i < te.Length; i++)
            {
                te[i] = new Exception("Komunikat " + i);
                te[i].HelpLink = "http://www.fizyka.umk.pl/~jacek/";
            }

            //int[,] ti2 = new int[2, 3] { { 0, 1, 2 }, { 3, 4, 5 } };
            int[,] ti2 = new int[2, 3];
            for (int i = 0; i < 2; i++)
                for (int j = 0; j < 3; j++)
                    ti2[i, j] = 3 * i + j;

            //Console.WriteLine();

            foreach (Exception ei in te)
            {
                //ei = new Exception("Nowy obiekt"); //błąd
                ei.Source = AppDomain.CurrentDomain.FriendlyName;
                Console.WriteLine(ei.Message + " - " + ei.Source);
            }

            Console.WriteLine();

            int[,] i2 = new int[2, 3] { { 0, 1, 2 }, { 3, 4, 5 } };
            foreach (int i in ti2) Console.Write("" + i + ";");
            foreach (var i in ti2) Console.Write("" + i + ";");
            Console.WriteLine();

            Console.WriteLine();

            int[] losy = new int[30];
            Random r = new Random();
            for (int indeks = 0; indeks < losy.Length; indeks++)
                losy[indeks] = r.Next(100);

            string s = "Przed sortowaniem: ";
            foreach (int los in losy) s += los.ToString() + " ";
            Console.WriteLine(s);

            Array.Sort(losy);

            s = "Po sortowaniu: ";
            foreach (int los in losy) s += los.ToString() + " ";
            Console.WriteLine(s);

            Console.WriteLine();
            
            //uruchomienie tego kodu skończy się błędem
            Exception[] wyjatki = new Exception[100];
            //Random r = new Random();
            for (int indeks = 0; indeks < wyjatki.Length; indeks++)
            {
                wyjatki[indeks] = new Exception(r.Next(100).ToString());                
            }
            //Array.Sort(wyjatki);            
            s = "Przed sortowaniem: ";
            foreach (Exception wyjatek in wyjatki) s += wyjatek.Message + " ";
            Console.WriteLine(s);

            Array.Sort(wyjatki,new PorownywaczWyjatkow());

            s = "Po sortowaniu: ";
            foreach (Exception wyjatek in wyjatki) s += wyjatek.Message + " ";
            Console.WriteLine(s);

            Console.WriteLine("\n-----------------\n");
        }

        static void Listy()
        {
            Console.WriteLine("Listy:\n");

            int rozmiar = 30;
            Random r = new Random();
            List<int> l = new List<int>(new int[rozmiar]);
            for (int i = 0; i < rozmiar; i++) l[i] = r.Next(100);
            l.AddRange(new int[10]);
            int[] i5 = { -1, -1, -1, -1, -1 };
            l.InsertRange(rozmiar / 2, i5);
            l.Insert(0, 1);

            //tu kryją się błędy
            //for (int i = 0; i < rozmiar; i++)
            for (int i = 0; i < l.Count; i++)
            {
                if (l[i] > 20)
                {
                    l.RemoveAt(i);
                    i--;
                }
            }

            l.Sort();

            string s = "Elementy listy: ";
            foreach (object ai in l) s += ai.ToString() + " ";
            Console.WriteLine(s);

            Console.WriteLine("\n-----------------\n");
        }

        static void Slownik()
        {
            Console.WriteLine("Słownik SortedList:\n");

            SortedList<string, string> artysci = new SortedList<string, string>();
            artysci.Add("Sting", "Gordon Matthew Sumner");
            artysci.Add("Bolesław Prus", "Aleksander Głowacki");
            artysci.Add("Pola Negri", "Barbara Apolonia Chałupiec");
            artysci.Add("John Wayne", "Marion Michael Morrison");
            artysci.Add("Chico", "Leonard Marx");
            artysci.Add("Harpo", "Arthur Marx");
            artysci.Add("Groucho", "Julius Marx");
            artysci.Add("Bono", "Paul Hewson");
            artysci.Add("Ronaldo", "Luiz Nazario de Lima");
            artysci.Add("Madonna", "Madonna Louise Veronica Ciccone");
            artysci.Add("Gabriela Zapolska", "Maria G. Śnieżko-Błocka");

            string komunikat = "Zawartość listy:\n";
            foreach (KeyValuePair<string, string> artysta in artysci)
                komunikat += artysta.Key + " - " + artysta.Value + "\n";
            Console.WriteLine(komunikat);

            Console.WriteLine("\n-----------------\n");
        }

        static void KolejkaStos()
        {
            Console.WriteLine("Kolejka i stos:\n");

            int rozmiar = 10;
            Queue<int> kolejka = new Queue<int>(rozmiar);
            Stack<int> stos = new Stack<int>(rozmiar);
            for (int i = 0; i < rozmiar; ++i)
            {
                kolejka.Enqueue(i);
                stos.Push(i);
            }

            string s = "Elementy zdjęte z kolejki (" + kolejka.Count + " elementów): ";
            for (int i = 0; i < rozmiar; ++i) s += kolejka.Dequeue().ToString() + " ";
            Console.WriteLine(s);
            s = "Elementy zdjęte ze stosu (" + stos.Count + " elementów):  ";
            for (int i = 0; i < rozmiar; ++i) s += stos.Pop().ToString() + " ";
            Console.WriteLine(s);

            Console.WriteLine("\n-----------------\n");
        }

        static private int Suma(params int[] lista)
        {
            Console.WriteLine("Liczba argumentów: " + lista.Length.ToString());
            int suma = 0;
            foreach (int liczba in lista) suma += liczba;
            return suma;
        }

        static void Params()
        {
            Console.WriteLine("Tablice jako argumenty metod oraz metody z nieokreśloną liczbą argumentów:\n");

            int suma = Suma(new int[] { 1, 2, 3 });
            Console.WriteLine("Suma: " + suma.ToString());

            suma = Suma(1, 2, 3);
            Console.WriteLine("Suma: " + suma.ToString());

            Console.WriteLine("\n-----------------\n");
        }

        static int[] _metoda(int rozmiar)
        {
            int[] wynik = new int[rozmiar];
            Random r = new Random();
            for (int i = 0; i < rozmiar; ++i)
            {
                wynik[i] = r.Next();
            }
            return wynik;
        }

        IEnumerable<int> metoda(int rozmiar)
        {
            Random r = new Random();
            for (int i = 0; i < rozmiar; ++i)
            {
                yield return r.Next();
            }
            yield break;
        }

        static void Yield()
        {
            Console.WriteLine("Słowo kluczowe yield:\n");

            //int[] ti = _metoda(10);
            int[] ti = _metoda(10).ToArray();
            foreach (int element in ti) Console.WriteLine(element.ToString());

            Console.WriteLine("\n-----------------\n");
        }

        static public void PokazInformacje(
            string zwyklyArgument,
            [CallerMemberName] string memberName = "",
            [CallerFilePath] string sourceFilePath = "",
            [CallerLineNumber] int sourceLineNumber = 0)
        {
            Console.WriteLine("Informacje o miejscu wywołania metody:");
            Console.WriteLine("nazwa elementu składowego: " + memberName);
            Console.WriteLine("ścieżka pliku z kodem źródłowym: " + sourceFilePath);
            Console.WriteLine("numer linii, w której nastąpiło wywołanie: " + sourceLineNumber);
        }

        static void CallerInformation()
        {
            Console.WriteLine("Caller information:\n");

            PokazInformacje("przykładowy łańcuch");

            Console.WriteLine("\n-----------------\n");
        }

        [Nadzór("J. Matulewski", "E. Burska", CzySprawdzone = true)]
        static public void PrzykladMetodyZAtrybutem()
        {
        }

        static void WyświetlInformacjeONadzorzeKlasy(Type typ)
        {
            //odczytywanie informacji z atrybutów klas (może być wiele instancji)
            NadzórAttribute[] atrybuty = (NadzórAttribute[])Attribute.GetCustomAttributes(typ, typeof(NadzórAttribute));
            if (atrybuty == null || atrybuty.Length == 0) Console.WriteLine("Atrybuty \"Weryfikacja\" nie zostały użyte w klasie {0}.", typ.Name);
            else
            {
                foreach (NadzórAttribute atrybut in atrybuty)
                    Console.WriteLine("Autor klasy {0}: {1}, osoba odpowiedzialna: {2}, czy sprawdzone: {3}",
                        typ.Name,
                        atrybut.Autor, atrybut.OsobaOdpowiedzialna,
                        atrybut.CzySprawdzone ? "tak" : "nie");
            }

            //odczytywanie informacji z atrybutów publicznych metod wskazanej klasy (może być wiele instancji)
            System.Reflection.MemberInfo[] informacjeOMetodach = typ.GetMethods();
            foreach (System.Reflection.MemberInfo informacjaOMetodzie in informacjeOMetodach)
            {
                atrybuty = (NadzórAttribute[])Attribute.GetCustomAttributes(informacjaOMetodzie, typeof(NadzórAttribute));
                if (atrybuty == null || atrybuty.Length == 0) Console.WriteLine("Atrybuty \"Weryfikacja\" nie zostały użyte w metodzie {0}.{1}.", typ.Name, informacjaOMetodzie.Name);
                else
                {
                    foreach (NadzórAttribute atrybut in atrybuty)
                        Console.WriteLine("Autor metody {0}.{1}: {2}, osoba odpowiedzialna: {3}, czy sprawdzone: {4}",
                            typ.Name, informacjaOMetodzie.Name,
                            atrybut.Autor, atrybut.OsobaOdpowiedzialna,
                            atrybut.CzySprawdzone ? "tak" : "nie");
                }
            }
        }
    }

    [System.AttributeUsage(System.AttributeTargets.All, AllowMultiple = true, Inherited = false)]
    public class NadzórAttribute : System.Attribute
    {
        public string Autor { get; set; }
        public string OsobaOdpowiedzialna { get; set; }
        public bool CzySprawdzone { get; set; }

        public NadzórAttribute(string Autor, string OsobaOdpowiedzialna)
        {
            this.Autor = Autor;
            this.OsobaOdpowiedzialna = OsobaOdpowiedzialna;
        }
    }


    class Klasa
    {
        public delegate void Callback(object sender, DateTime czasZakonczeniaMetody);

        public Callback DelegacjaMetodaZakonczona;
        public event Callback ZdarzenieMetodaZakonczona;

        public void Metoda()
        {
            Console.WriteLine("Metoda - początek");

            //tu długie działanie metody

            Console.WriteLine("Metoda - tuż przed końcem");

            if (DelegacjaMetodaZakonczona != null)
                DelegacjaMetodaZakonczona(this, DateTime.Now);
            if (ZdarzenieMetodaZakonczona != null)
                ZdarzenieMetodaZakonczona(this, DateTime.Now);

            Console.WriteLine("Metoda - koniec");
        }
    }
}
