﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Phonebook
{
    struct PhoneBookEntry
    {
        public string name;
        public string phone;
    }

    public partial class Form1 : Form
    {
        // Pole przechowujące listę obiektów PhoneBookEntry.
        private List<PhoneBookEntry> phoneList =
            new List<PhoneBookEntry>();

        public Form1()
        {
            InitializeComponent();
        }

        // Metoda ReadFile() odczytuje zawartość pliku
        // PhoneList.txt i przechowuje ją w postaci obiektów
        // PhoneBookEntry w kolekcji phoneList.
        private void ReadFile()
        {
            try
            {
                StreamReader inputFile; // Zmienna pozwalająca na odczyt danych z pliku.
                string line;            // Zmienna przechowująca wiersz danych z pliku.

                // Utworzenie egzemplarza struktury PhoneBookEntry.
                PhoneBookEntry entry = new PhoneBookEntry();

                // Utworzenie tablicy ogranicznika.
                char[] delim = { ',' };

                // Otworzenie pliku PhoneList.txt.
                inputFile = File.OpenText("PhoneList.txt");

                // Odczytanie wierszy danych z pliku.
                while (!inputFile.EndOfStream)
                {
                    // Odczytanie wiersza z pliku.
                    line = inputFile.ReadLine();

                    // Tokenizacja wiersza.
                    string[] tokens = line.Split(delim);

                    // Umieszczenie tokenów w obiekcie entry.
                    entry.name = tokens[0];
                    entry.phone = tokens[1];

                    // Dodanie obiektu entry do kontenera List.
                    phoneList.Add(entry);
                }
            }
            catch (Exception ex)
            {
                // Wyświetlenie komunikatu błędu.
                MessageBox.Show(ex.Message);
            }
        }

        // Metoda DisplayNames() wyświetla listę osób
        // w kontrolce namesListBox.
        private void DisplayNames()
        {
            foreach (PhoneBookEntry entry in phoneList)
            {
                nameListBox.Items.Add(entry.name);
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // Odczyt zawartości pliku PhoneList.txt.
            ReadFile();

            // Wyświetlenie osób.
            DisplayNames();
        }

        private void nameListBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            // Pobranie indeksu zaznaczonego elementu.
            int index = nameListBox.SelectedIndex;

            // Wyświetlenie numeru telefonu wybranej osoby.
            phoneLabel.Text = phoneList[index].phone;
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
