// Soln 9_4.cpp
// Aby uywa funkcji rand_s, konieczne jest uprzednie zdefiniowanie  _CRT_RAND_S.
#define _CRT_RAND_S             // Dla bezpiecznego generatora liczb losowych.
#include <iostream>
#include <iomanip>
#include <cstdlib>              // Dla funkcji rand_s.

using std::cout;
using std::endl;
using std::setw;

class CBinaryTree
{
private:
  class CNode
  {
  public:
    // Konstruktor wza.
    CNode(int n) : value(n), m_pLeft(0), m_pRight(0) {}

    // Tworzy list wzw.
    void listNode()
    {

      if(m_pLeft != 0)                 // Jeli jest lewy wze,
        m_pLeft->listNode();           // wywietla jego warto.

      cout << setw(12) << value;       // Wysya na wyjcie warto biecego wza.
      if(++listCount % 5 == 0)
        cout << endl;

      if(m_pRight != 0)                // Jeli jest prawy wze,
        m_pRight->listNode();          // wywietla jego warto.
    }

    int value;                         // Warto wza.
    CNode* m_pLeft;                    // Wskanik do lewego wza.
    CNode* m_pRight;                   // Wskanik do prawego wza.
    static int listCount;              // Licznik wysyanych na wyjcie wartoci.
  };

public:
  CBinaryTree() : m_pRoot(0){}         // Konstruktor.

  void add(int n);                     // Dodaje warto do drzewa.
  void add(int n, CNode* pNode);       // Dodaje n wzgldem wza pNode.

  // Tworzy list wzw.
  void listNodes()
  {
    CNode::listCount = 0;
    if(m_pRoot == 0)
      cout << "Binary tree is empty." << endl;
    else 
      m_pRoot->listNode();
  }

private:
   CNode* m_pRoot;                     // Wskanik do wza gwnego.
};

int CBinaryTree::CNode::listCount = 0; // Inicjacja skadowej statycznej.

// Dodanie wartoci do drzewa.
void CBinaryTree::add(int n)
{
  if(m_pRoot == 0)                     // Jeli nie ma wza gwnego,
    m_pRoot = new CNode(n);            // staje si nim nowy wze.
  else                                 // W przeciwnym przypadku,
    add(n, m_pRoot);                   // wze ten zostaje dodany (recursywanie).
}

// Dodanie wartoci wzgldem danego wza.
void CBinaryTree::add(int n, CNode* pNode)
{
  if(n == pNode->value)                // Jeli warto jest rwna biecemu wzowi.
  { // Rwne wartoci zawsze dodaje jako lewy wze.
    CNode* pNewNode = new CNode(n);    // Tworzy nowy wze dla wartoci.
    CNode* pTemp = pNode->m_pLeft;     // Zapisuje lewy wskanik dla biecego wza,
    pNode->m_pLeft = pNewNode;         // a nastpnie ustawia go na ten nowy wze.
    pNewNode->m_pLeft = pTemp;         // Lewy wskanik nowego wza wskazuje stary lewy wze.
  }
  else if(n > pNode->value)            // Jeli nowa warto jest wiksza od wartoci prawego wza,
  {                                    // musi pj na praw stron.
    if(pNode->m_pRight == 0)           // Jeli wic nie ma prawego wza,
      pNode->m_pRight = new CNode(n);  // ten nowy wze bdzie prawym wzem.
    else                               // W przeciwnym przypadku
      add(n, pNode->m_pRight);         // zostanie dodany pod prawym wzem (rekursywnie).
  }
  else                                 // Nowa liczba jest mniejsza od wartoci biecego wza.
  {
    if(pNode->m_pLeft == 0)            // Jeli wic nie ma lewego wza,
      pNode->m_pLeft = new CNode(n);   // ten nowy wze bdzie lewym wzem.
    else                               // W przeciwnym razie
      add(n, pNode->m_pLeft);          // zostanie dodany pod lewym wzem (rekursywnie).
  }
}


int main()
{
  CBinaryTree tree;                    // Tworzy drzewo binarne.
  unsigned int number = 0;             // Zapisuje liczb do dodania do drzewa.

  cout << "Losowe wartoci wstawione do drzewa:" << endl;

  // Dodanie 100 losowych liczb do drzewa.
  for(int i = 0 ; i<100 ; i++)
  {
    if(rand_s(&number) != 0)
      cout << "Awaria generatora liczb losowych!" << endl;
    tree.add(number);
    cout << setw(12) << number;
    if((i+1) % 5 == 0)
      cout << endl;
  }
  cout << endl << "Dane wyjciowe z drzewa:" << endl;
  tree.listNodes();

   return 0;
}
