// Plik nagowkowy Stack.h dla projektu Cw9_14.
// Stos przechowujcy obiekty dowolnej klasy referencyjnej.
#pragma once

ref class Stack
{
private:
  // Definicja elementw do przechowywania na stosie.
  ref struct Item
  {
    Object^ Obj;                  // Uchwyt do obiektu w tym elemencie.
    Item^ Next;                   // Uchwyt do elementu na stosie lub nullptr.

    // Konstruktor
    Item(Object^ obj, Item^ next): Obj(obj), Next(next){}
  };

  Item^ Top;                       // Uchwyt do elementu, ktry znajduje si na wierzchu.

public:
  // Dodanie obiektu do stosu.
  void Push(Object^ obj)
  {
    Top = gcnew Item(obj, Top);     // Utworzenie nowego elementu i umieszczenie go na wierzchu.
  }

  // Usunicie obiektu ze stosu.
  Object^ Pop()
  {  
    if(Top == nullptr)                 // Jeeli stos jest pusty,
      return nullptr;                  // zwraca nullptr.

    Object^ obj = Top->Obj;            // Pobieranie obiektu z elementu.
    Top = Top->Next;                   // Wstawienie nastpnego elementu na wierzch. 
    return obj;
  }
};
