// Plik nagwkowy CandyBox.h w projekcie Cw9_05.
#pragma once
#include "Box.h"
#include <iostream>
using std::cout;
using std::endl;

class CCandyBox: public CBox
{
  public:
    char* m_Contents;

    // Funkcja klasy pochodnej obliczajca pojemno.
    double Volume() const
    { return m_Length*m_Width*m_Height; }

    // Konstruktor ustawiajcy wymiary i zawarto
    // za pomoc jawnego wywoania konstruktora klasy CBox.
    CCandyBox(double lv, double wv, double hv, char* str = "Candy")
                                          :CBox(lv, wv, hv)  // Konstruktor
    {
      cout << endl <<"Konstruktor constructor2 klasy CCandyBox zosta wywoany.";
      m_Contents = new char[ strlen(str) + 1 ];
      strcpy_s(m_Contents, strlen(m_Contents), str);
    }

    // Konstruktor ustawiajcy zawarto
    // automatycznie wywouje domylny konstruktor klasy CBox.
    CCandyBox(char* str = "Candy")               // Konstruktor
    {
      cout << endl << "Konstruktor constructor1 klasy CCandyBox zosta wywoany.";
      m_Contents = new char[ strlen(str) + 1 ];
      strcpy_s(m_Contents, strlen(m_Contents), str);
    }

    ~CCandyBox()                                 // Destruktor
    {
      cout << "Destruktor klasy CCandyBox zosta wywoany." << endl;
      delete[] m_Contents;
    }
};
