// Soln8_1.cpp

#include <iostream>                   // Dla funkcji wejcia-wyjcia.

using std::cout;
using std::endl;

#define TRUE 1
#define FALSE 0

class CEstimatedInteger
{
private:
   int val;
   int bEst;

public:
  CEstimatedInteger(int i=0, int e=0) : val(i), bEst(e){}

   void setEstimated(int e)
   {
      bEst = (!e) ? FALSE : TRUE;
   }

   void print();

   // Funkcje pomocnicze.
   CEstimatedInteger Add(const CEstimatedInteger& b) const;
};

void CEstimatedInteger::print()
{
   if (bEst)
      cout << 'E';
   cout << val;
}

CEstimatedInteger CEstimatedInteger::Add(const CEstimatedInteger& b) const
{
   CEstimatedInteger t(val+b.val);
   if (bEst || b.bEst)
      t.bEst = TRUE;

   return t;
}

CEstimatedInteger operator+(const CEstimatedInteger& a, const CEstimatedInteger& b)
{
   return a.Add(b);
}

int main()
{
   CEstimatedInteger a=3, c;
   CEstimatedInteger b(5,TRUE);

   cout << "a=";
   a.print();
   cout << endl;

   cout << "b=";
   b.print();
   cout << endl;

   c = a + b;
   cout << "c=";;
   c.print();
   cout << endl;

   return 0;
}
