// Cw8_09.cpp: main project file.
// Przeadowywanie operatorw w klasie wartoci Length.
#include "stdafx.h"
using namespace System;

value class Length
{
private:
   int metry;                              // Metry.
   int centymetry;                            // Centymetry.

public:
   static initonly int cmNaMetr = 100;

   // Konstruktor.
   Length(int m, int cm) : metry(m), centymetry(cm){ }

   // Dugo jako acuch.
   virtual String^ ToString() override
   { return metry+L" metrw " + centymetry + L" centymetrw"; }

   // Operator dodawania.
   Length operator+(Length len)
   {
      int cmTotal = centymetry + len.centymetry + cmNaMetr * ( metry + len.metry );
      return Length(cmTotal/cmNaMetr, cmTotal%cmNaMetr);
   }

  // Operator dzielenia.
  static Length operator/(Length len, double x)
  {
    int ins = safe_cast<int>((len.metry * cmNaMetr + len.centymetry) / x);
    return Length(ins / cmNaMetr, ins % cmNaMetr);
  }

  static Length operator*(double x, Length len); // Mnoenie przed przez liczb typu double.
  static Length operator*(Length len, double x); // Mnoenie po przez liczb typu double.
};

Length Length::operator*(double x, Length len)
{
   int ins = safe_cast<int>(x * len.centymetry + x * len.metry * cmNaMetr);
   return Length(ins / cmNaMetr, ins % cmNaMetr);
}

Length Length::operator*(Length len, double x)
{ return operator*(x, len);  }

int main(array<System::String ^> ^args)
{
  Length len1 = Length(6, 9);
  Length len2 = Length(7, 8);
  double factor = 2.5;

  Console::WriteLine(L"{0} plus {1} rwna si {2}", len1, len2, len1+len2);  
  Console::WriteLine(L"{0} razy {1} rwna si {2}", factor, len2, factor*len2);  
  Console::WriteLine(L"{1} razy {0} rwna si {2}", factor, len2, len2*factor);  
  Console::WriteLine(L"Suma {0} i {1} podzielona przez {2} rwna si {3}",
                                      len1, len2, factor, (len1+len2)/factor);
  return 0;
}
