// Cw8_03.cpp
// wiczenie zastosowania przeadowanego operatora wikszoci.
#include <iostream>                      // Dla strumienia wejcia-wyjcia.
using std::cout;
using std::endl;

class CBox                               // Definicja klasy o zasigu globalnym.
{
  public:
    // Definicja konstruktora.
    CBox(double lv = 1.0, double wv = 1.0, double hv = 1.0):
                               m_Length(lv), m_Width(wv), m_Height(hv)
    {
      cout << endl << "Konstruktor zosta wywoany.";
    }

    // Funkcja obliczajca pojemno pudeka.
    double Volume() const
    {
      return m_Length*m_Width*m_Height;
    }

    bool operator>(const CBox& aBox) const;  // Przeadowanie operatora wikszoci.

    // Definicja destruktora.
    ~CBox()
    {
      cout << "Destruktor zosta wywoany." << endl;
    }

  private:
    double m_Length;                         // Dugo pudeka w centymetrach.
    double m_Width;                          // Szeroko pudeka w centymetrach.
    double m_Height;                         // Wysoko pudeka w centymetrach.
};

// Funkcja operatora wikszoci porwnujca
// pojemnoci dwch obiektw klasy CBox.
bool CBox::operator>(const CBox& aBox) const
{
  return this->Volume() > aBox.Volume();
}

int main()
{
  CBox smallBox(4.0, 2.0, 1.0);
  CBox mediumBox(10.0, 4.0, 2.0);
  CBox bigBox(30.0, 20.0, 40.0);

  if(mediumBox > smallBox)
    cout << endl
         << "Pudeko mediumBox jest wiksze ni smallBox.";

  if(mediumBox > bigBox)
    cout << endl
         << "Pudeko mediumBox jest wiksze ni bigBox.";
  else
    cout << endl
         << "Pudeko mediumBox nie jest wiksze ni bigBox";

  cout << endl;
  return 0;
}
