// Cw9_12.cpp
// Wywoywanie destruktorw w klasach pochodnych
// przy uyciu obiektw poprzez wskanik klasy bazowej.
#include "Box.h"                       // Dla klas CBox i CContainer.
#include "Can.h"                       // Dla klasy CCan (i CContainer).
#include "GlassBox.h"                  // Dla klasy CGlassBox (oraz CBox i CContainer).
#include <iostream>                    // Dla strumienia wejcia-wyjcia.
using std::cout;
using std::endl;

const double PI = 3.14159265;          // Globalna definicja zmiennej PI.

int main()
{
  // Wskanik do abstrakcyjnej klasy bazowej zainicjalizowany adresem obiektu klasy CBox.
  CContainer* pC1 = new CBox(2.0, 3.0, 4.0);

  CCan myCan(6.5, 3.0);                // Definicja obiektu klasy CCan.
  CGlassBox myGlassBox(2.0, 3.0, 4.0); // Definicja obiektu klasy CGlassBox.

  pC1->ShowVolume();                   // Wysanie na ekran pojemnoci obiektu klasy CBox.
  cout << endl << "Delete CBox" << endl;
  delete pC1;                          // Czyszczenie obszaru pamici wolnej.

  pC1 = new CGlassBox(4.0, 5.0, 6.0);  // Dynamiczne utworzenie obiektu klasy CGlassBox
  pC1->ShowVolume();                   // ...i wysanie na wyjcie jego pojemnoci...
  cout << endl << "Delete CGlassBox" << endl;
  delete pC1;                          // ...oraz jego usunicie.

  pC1 = &myCan;                        // Ustaw wskanik na adres obiektu myCan.
  pC1->ShowVolume();                   // Wylij na wyjcie pojemno obiektu klasy CCan.

  pC1 = &myGlassBox;                   // Ustaw wskanik na adres obiektu myGlassBox.
  pC1->ShowVolume();                   // Wylij na wyjcie pojemno obiektu klasy CGlassBox.

  cout << endl;
  return 0;
}
