// Cw7_16.cpp: main project file.
// Uywanie waciwoci skalarnych.
#include "stdafx.h"

using namespace System;

// Klasa definiujca wzrost osoby.
value class Height
{
private:
  // Zapisuje wzrost w stopach i calach.
  int feet;
  int inches;

  literal int inchesPerFoot = 12;
  literal double inchesToMeters = 2.54/100;

public:
  // Tworzy wzrost z wartoci zmiennej inches.
  Height(int ins)
  {
    feet = ins / inchesPerFoot;
    inches = ins % inchesPerFoot;
  }

  // Tworzy wzrost z wartoci zmiennych feet i inches.
  Height(int ft, int ins) : feet(ft), inches(ins){}

  // Wzrost w metrach.
  property double meters                         // Waciwo skalarna.
  {
    // Zwraca warto waciwoci.
    double get() 
    { 
      return inchesToMeters*(feet*inchesPerFoot+inches);
    }

    // Definicja funkcji set() waciwoci znajdowaaby si tutaj...
  }

  // Tworzenie acuchowej reprezentacji obiektu.
  virtual  String^ ToString() override
  {
    return feet + L" stp "+ inches + L" cale";
  }
};

// Klasa definiujca wag osoby.
value class Weight
{
private:
  int lbs;
  int oz;

  literal int ouncesPerPound = 16;
  literal double lbsToKg = 1.0/2.2;

public:
  Weight(int pounds, int ounces)
  {
    lbs = pounds;
    oz = ounces;
  }
  
  property int pounds                            // Waciwo skalarna.
  {
    int get() { return lbs;  }
    void set(int value) {  lbs = value;  }
  }
  
  property int ounces                            // Waciwo skalarna.
  {
    int get() { return oz;  }
    void set(int value) {  oz = value;  }
  }

  property double kilograms                      // Waciwo skalarna.
  {
    double get() { return lbsToKg*(lbs + oz/ouncesPerPound);  }
  }

  virtual String^ ToString() override
  { return lbs + L" funtw " + oz + L" uncji"; }
};

// Klasa definiujca osob.
ref class Person
{
private:
  Height ht;
  Weight wt;

public:
  property String^ Name;                         // Uproszczona waciwo skalarna.

  Person(String^ name, Height h, Weight w) : ht(h), wt(w)
  {
    Name = name;
  }

  Height getHeight(){ return ht;  }
  Weight getWeight(){ return wt;  }
};

int main(array<System::String ^> ^args)
{
  Weight hisWeight = Weight(185, 7);
  Height hisHeight = Height(6, 3);
  Person^ him = gcnew Person(L"Fred", hisHeight, hisWeight);

  Weight herWeight = Weight(105, 3);
  Height herHeight = Height(5, 2);
  Person^ her = gcnew Person(L"Freda", herHeight, herWeight);

  Console::WriteLine(L"To jest {0}", her->Name);
  Console::WriteLine(L"Ona way {0:F2} kilogramw.", 
                                                    her->getWeight().kilograms);
  Console::WriteLine(L"Ma wzrostu {0}, czyli {1:F2} metrw.",
                                      her->getHeight(),her->getHeight().meters);

  Console::WriteLine(L"To jest {0}", him->Name);
  Console::WriteLine(L"On way {0}.", him->getWeight());
  Console::WriteLine(L"Ma wzrostu {0}, czyli {1:F2} metrw.",
                                       him->getHeight(),him->getHeight().meters);
  return 0;
}
