// Cw7_10.cpp
// Uywanie wskanika this.
#include <iostream>
using std::cout;
using std::endl;

class CBox                             // Definicja klasy o zasigu globalnym.
{
  public:
    // Definicja konstruktora.
    CBox(double lv = 1.0, double bv = 1.0, double hv = 1.0)
    {
      cout << endl << "Konstruktor zosta wywoany.";
      m_Length = lv;                   // Ustawianie wartoci
      m_Width = bv;                    // zmiennych skadowych.
      m_Height = hv;
    }

    // Funkcja obliczajca pojemno pudeka.
    double Volume()
    {
      return m_Length*m_Width*m_Height;
    }

    // Funkcja porwnujca dwa pudeka, ktra zwraca true (1),
    // jeeli pierwsze jest wiksze ni drugie, oraz false (0) w przeciwnym przypadku.
    int Compare(CBox xBox)
    {
      return this->Volume() > xBox.Volume();
    }

  private:
    double m_Length;                   // Dugo pudeka w centymetrach.
    double m_Width;                    // Szeroko pudeka w centymetrach.
    double m_Height;                   // Wysoko pudeka w centymetrach.

};

int main()
{
  CBox match(2.2, 1.1, 0.5);           // Deklaracja pudeka match.
  CBox cigar(8.0, 5.0,1.0);            // Deklaracja pudeka cigar.

  if(cigar.Compare(match))
    cout << endl
         << "Pudeko match jest mniejsze ni cigar";
  else
    cout << endl
         << "Pudeko match jest rwne lub wiksze od pudeka cigar";

  cout << endl;
  return 0;
}
