// Soln6_3ANSI.cpp
// Program implementujcy kalkulator obsugujcy nawiasy.

#include <iostream>                   // Dla funkcji wejcia-wyjcia.
#include <cstdlib>                    // Dla funkcji exit().
#include <cctype>                     // Dla funkcji isdigit().
#include <cstring>                    // Dla funkcji strcpy().
using std::cin;
using std::cout;
using std::endl;

void eatspaces(char* str);            // Funkcja usuwajca biae znaki.
double expr(char* str);               // Funkcja obliczajca warto wyraenia.
double term(char* str, int& index);   // Funkcja analizujca skadnik.
double number(char* str, int& index); // Funkcja rozpoznajca liczb.
char* extract(char* str, int& index); // Funkcja wydobywajca podacuch.
void error(char* str, int index);     // Funkcja identyfikujca bd.

const int MAX = 80;                   // Maksymalna dugo wyraenia, 
                                      // wliczajc '\0'.
int main()
{
   char buffer[MAX] = {0};    // Miejsce na wyraenia do obliczenia.

   cout << endl
        << "Witaj w swoim przyjaznym kalkulatorze."
        << endl
        << "Wprowad wyraenie lub pusty wiersz, aby zakoczy."
        << endl;

   for(;;)
   {
      cin.getline(buffer, sizeof buffer);   // Wczytanie wiersza danych.
      eatspaces(buffer);                    // Usunicie biaych znakw.

      if(!buffer[0])                        // Pusty wiersz powoduje zakoczenie dziaania kalkulatora.
         return 0;

      cout << "\t= " << expr(buffer)        // Wysanie na wyjcie wartoci wyraenia.
           << endl << endl;
   }
}


// Funkcja usuwajca spacje z acucha.
void eatspaces(char* str)
{
   int i = 0;                             
   int j = 0;                             

   while((*(str + i) = *(str + j++)) != '\0')  // Ptla dziaa dopki nie zostanie
                                               // skopiowany znak \0.
      if(*(str + i) != ' ')                    // Zwikszanie i dopki
         i++;                                  // znak nie jest spacj.
   return;
}

// Funkcja obliczajca wyraenie arytmetyczne.
double expr(char* str)
{
  double value = 0.0;                  // Zmienna przechowujca wynik.
  int index = 0;                       // Pilnuje pozycji aktualnego znaku.

  value = term(str, index);            // Pobiera pierwszy skadnik.

  for(;;)                              // Ptla nieskoczona, wszysto odbywa si w rodku.
  {
    switch(*(str + index++))           // Podejmuje dziaania na podstawie biecego znaku.
    {
      case '\0':                       // Jestemy na kocu acucha,
         return value;                 // a wic zwracamy, co mamy.

      case '+':                        // Znaleziono znak +, a wic
         value += term(str, index);    // dodajemy nastpny skadnik.
         break;

      case '-':                        // Znaleziono znak -, a wic
         value -= term(str, index);    // odejmujemy nastpny skadnik.
         break;

      default:                         // Jeli doszlimy tutaj, podany
         cout << endl                  // acuch jest bdny.
              << "Arrrgh!*#!! Tu jest bd."
              << endl;
         error(str, index-1);
         exit(1);
    }
  }
}

// Funkcja obliczajca warto skadnika.
double term(char* str, int& index)
{
  double value = 0.0;                  // Miejsce do gromadzenia wyniku.

  value = number(str, index);          // Pobranie pierwszej liczby skadnika.

  // Ptla dziaa dopki jest dobry operator.
  while((*(str + index) == '*') || (*(str + index) == '/'))
  {

    if(*(str + index) == '*')          // Jeli jest operator mnoenia,
      value *= number(str, ++index);   // mnoymy przez nastpn liczb.

    if(*(str + index) == '/')          // Jeli dzielenia,
      value /= number(str, ++index);   // dzielimy przez nastpn liczb.
  }
  return value;                        // Skoczylimy, a wic zwracamy, co mamy.
}

// Funkcja rozpoznajca liczby w acuchu.
double number(char* str, int& index)
{
  double value = 0.0;                  // Zapisanie wartoci.

  if(*(str + index) == '(')           // Pocztek nawiasu.
  {
    char* psubstr = 0;               // Wskanik dla odejmowania.
    psubstr = extract(str, ++index); // Wydobycie odejmowania w nawiasach.
    value = expr(psubstr);           // Warto podacucha.
    delete[]psubstr;                 // Wyczyszczenie wolnego obszaru.
    return value;                    // Zwrcenie wartoci podacucha.
  }

  while(isdigit(*(str + index)))       // Ptla zbierajca wiodce cyfry.
    value = 10*value + (*(str + index++) - '0');

                                       // Jeli jestemy tu, znalelimy co innego ni cyfra.
  if(*(str + index) != '.')            // Sprawdzamy czy jest to przecinek dziesitny.
    return value;                      // Jeli nie, wzracamy warto.

  double factor = 1.0;                 
  while(isdigit(*(str + (++index))))   
  {
    factor *= 0.1;                     
    value = value + (*(str + index) - '0')*factor;   // Dodanie miejsca dziesitnego.
  }

  return value;                        // Po zakoczeniu dziaania ptli, koniec.
}

// Funkcja wydobywajca podacuch z nawiasw. 
char* extract(char* str, int& index)
{
  char buffer[MAX];                   // Tymczasowe miejsce do przechowania podacucha.
  char* pstr = 0;                     // Wskanik do nowego acucha.
  int numL = 0;                       // Licznik znalezionych nawiasw otwierajcych.
  int bufindex = index;               // Zapisanie wartoci pocztkowej index.

  do
  {
    buffer[index - bufindex] = *(str + index);
    switch(buffer[index - bufindex])
    {
      case ')':
        if(numL == 0)
        {
          size_t size = index - bufindex;
          buffer[index - bufindex] = '\0';  // Zastpnienie znaku ) znakiem '\0'. 
          ++index;
          pstr = new char[index - bufindex];
          if(!pstr)
          {
            cout << "Nie udana prba przydzielenia pamici,"
                 << " program zostanie zamknity.";
            exit(1);
          }
          strcpy_s(pstr, index-bufindex, buffer); // Skopiowanie podacucha do nowego miejsca w pamici.
          return pstr;                 // Zwrcenie tego podacucha.
        }
        else
          numL--;                      // Zmniejszenie liczby znakw (.
          break;

      case '(':
        numL++;                        // Zwikszenie liczby znakw (.
        break;
      }
  } while(*(str + index++) != '\0'); // Ptla

  cout << "Nastpio wyjcie poza koniec wyraenia, dane wejciowe musz by niepoprawne."
       << endl;
  exit(1);
  return pstr;
}

// Funkcja identyfikujca bd.
void error(char* str, int index)
{
   cout << str << endl;
   for (int i=0; i<index; i++)
      cout << ' ';
   cout << '^' << endl;
}
