// Name.cpp  implementacja klasy Name.
#include "Name.h"                                // Definicja klasy Name.
#include "DebugStuff.h"                          // Kontrola kodu debugujcego.
#include <cstring>                               // Dla funkcji acuchowych w stylu C.
#include <cassert>                               // Dla asercji.
#include <iostream>
using namespace std;
// Konstruktor domylny.
Name::Name()
{
#ifdef CONSTRUCTOR_TRACE
  // led wywoania konstruktora.
  cerr << "\nKonstruktor domylny klasy Name zosta wywoany.";
#endif
  pFirstname = pSurname = "\0";
}
// Konstruktor.
Name::Name(const char* pFirst, const char* pSecond):
                                     pFirstname(pFirst), pSurname(pSecond) 
{
  // Sprawdzanie, czy argumenty nie s zerowe.
  assert(pFirst != 0);
  assert(pSecond != 0);
#ifdef CONSTRUCTOR_TRACE
  // ledzenie wywoa konstruktora.
  cout << "\nKonstruktor klasy Name zosta wywoany.";
#endif
}

  pFirstname = new char[strlen(pFirst)+1];
  strcpy(pFirstname, pFirst);
  pSurname = new char[strlen(pSecond)+1];
  strcpy(pSurname, pSecond);
}


// Zwracanie penej nazwy w postaci acucha zawierajcego imi, spacj i nazwisko.
// Argument musi by adresem tablicy znakw wystarczajcej do przechowania nazwy .char*.

char* Name::getName(char* pName) const
{
  assert(pName != 0);                                 // Weryfikacja niezerowych argumentw.

#ifdef FUNCTION_TRACE
  // ledzenie wywoa funkcji.
  cout << "\nName::getName() called.";
#endif

  strcpy(pName, pFirstname);                          // Kopiowanie imienia.
  strcat(pName, " ");                  // Doczenie spacji.
  return strcat(pName, pSurname);      // Doczenie nazwiska i zwrcenie wszystkiego.
} 

// Zwraca cakowit dugo nazwy.
size_t Name::getNameLength() const
{
#ifdef FUNCTION_TRACE
  // ledzenie wywoa funkcji.
  cout << "\nName::getNameLength() called.";
#endif
  return strlen(pFirstname)+strlen(pSurname)+1;
}
