// Ex8_7.cpp : main project file.
// Kalkulator CLR obsugujcy nawiasy.

#include "stdafx.h"

using namespace System;

ref class Box
{
public:
   Box()
   {
     Box(1.0, 1.0, 1.0);
   }

   Box(double lv, double wv, double hv)
   {
     lv = lv <= 0.0 ? 1.0 : lv;           // Zapewnienie dodatnich
     wv = wv <= 0.0 ? 1.0 : wv;           // wymiarw dla
     hv = hv <= 0.0 ? 1.0 : hv;           // obiektu.

     lngth = lv>wv ? lv : wv;          // Upewnienie si, e
     wdth = wv<lv ? wv : lv;           // length >= width.
     hght = hv;
   }

    double Volume() 
    {
      return lngth*wdth*hght;
    }

   property double height
   {
     double get() { return hght; }
   }

    property double width
   {
     double get() { return wdth; }
   }

     property double length
   {
     double get() { return lngth; }
   }

    // Przeciony operator dodawania.
    Box^ operator+(Box^ box)
    {
    // Nowy obiekt jest duszy i szerszy.
    return gcnew Box(lngth > box->lngth ? lngth : box->lngth,
                     wdth > box->wdth ? wdth : box->wdth,
                     hght + box->hght);
    }

    // Podzielenie jednego pudeka przez drugie.
    int operator/(Box^ box)
    {
    // Tymczasowa zmienna do przechowywania liczby w paszczynie poziomej.
    int tc1 = 0;
    // Tymczasowa zmienna do przechowywania liczy w paszczynie.
    int tc2 = 0;

    tc1 = safe_cast<int>(lngth/box->lngth)*
             safe_cast<int>(wdth/box->wdth); 	 

    tc2 = safe_cast<int>(lngth/box->wdth)*
             safe_cast<int>(wdth/box->lngth);  

    // Zwraca najlepsze dopasowanie.
    return static_cast<int>(hght/box->hght)*(tc1>tc2 ? tc1 : tc2);
    }

    // Mnoenie pudeka przez liczb cakowit.
    Box^ operator*(int n)
    {
      if(n%2 == 0)
        return gcnew Box(lngth, 2.0*wdth, (n/2)*hght);   // n jest parzysta
      else
        return gcnew Box(lngth, wdth, n*hght);           // n jest nieparzysta
    }

    // Operator zwracajcy woln przestrze w zapakowanym pudeku.
    double operator%(Box^ box)
    { return Volume() - (this/box)*box->Volume(); }

    // Funkcja sprawdzajca czy obiekt Box object jest >= staej.
    bool operator>=(double value)
    { return value <= this; }

    // Funkcja sprawdzajca czy obiekt Box jest <= staej.
    bool operator<=(double value)
    { return value >= this; }

    // Funkcja sprawdzajca czy staa jest > od obiektu Box.
    static bool operator>(double value, Box^ box)
    { return value > box->Volume(); }

    // Funkcja sprawdzajca czy staa jest < od obiektu Box.
    static bool operator<(double value, Box^ box)
    { return value < box->Volume(); }

    // Funkcja sprawdzajca czy obiekt Box jest > od staej.
    static bool operator>(Box^ box, double value)
    { return value < box; }

    // Funkcja sprawdzajca czy obiekt Box jest < od staej.
    static bool operator<(Box^ box, double value)
    { return value > box; }

    // Funkcja sprawdzajca czy staa jest >= od obiektu Box.
    static bool operator>=(double value, Box^ box)
    { return value >= box->Volume(); }

    // Funkcja sprawdzajca czy staa jest <= obiektowi Box.
    static bool operator<=(double value, Box^ box)
    { return value <= box->Volume(); }

    // Funkcja sprawdzajca czy staa jest == obiektowi Box.
    static bool operator==(double value, Box^ box)
    { return value == box->Volume(); }

    // Funkcja sprawdzajca czy obiekt Box jest == staej.
    static bool operator==(Box^ box, double value)
    { return value == box; }

    // Operator mnoenia CBox n*aBox.
    static Box^ operator*(int n, Box^ box)
    { return box*n; }

private:
   
   double lngth;             // Dugo pudeka.
   double wdth;              // Szeroko pudeka.
   double hght;              // Wysoko pudeka.
};

int main(array<System::String ^> ^args)
{
   Box^ candy = gcnew Box(1.5, 1.0, 1.0);             // Definicja cukierka.
   Box^ candyBox = gcnew Box(7.0, 4.5, 2.0);          // Definicja pudeka cukierkw.
   Box^ carton = gcnew Box(30.0, 18.0, 18.0);         // Definicja kartonu.

   // Obliczenie liczby cukierkw na pudeko.
   int numCandies = candyBox/candy;

   // Obliczenie liczby pudeek z cukierkami na karton.
   int numCboxes = carton/candyBox;

   // Obliczenie iloci marnowanego miesca w kartonie.
   double space = carton%candyBox;

   Console::WriteLine(L"W pudeku zmieci si {0} cukierkw.", numCandies);
   Console::WriteLine(L"W standardowym kartonie zmieci si {0} pudeek z cukierkami.", numCboxes);
   Console::WriteLine(L"Zmarnuje si {0} centymetrw..", space);

   Console::Write(L"ANALIZA PUDEKA NA CUKIERKI ROBIONEGO NA ZAMWIENIE (nic si nie marnuje)");

   // Wyprbowanie caego zestawu niestandardowych pudeek.
   for(double length = 3.0 ; length <= 7.5 ; length += 0.5)
      for(double width = 3.0 ; width <= 5.0 ; width += 0.5)
         for(double height = 1.0 ; height <= 2.5 ; height += 0.5)
         {
            // W kadym cyklu tworzone jest nowe pudelko.
            Box^ tryBox = gcnew Box(length, width, height);

            if(carton%tryBox < tryBox->Volume() &&
                               tryBox % candy == 0.0 && tryBox/candy >= 30)
            {
               Console::Write(L"\n\nPrbne pudeko L = {0}", tryBox->length);
               Console::WriteLine(L" W = {0} H = {1}", tryBox->width, tryBox->height);
               Console::Write(L"Prbne pudeko zawiera {0} cukierkw.", tryBox/candy);
               Console::WriteLine(L"W kartonie zmieci si {0} takich pudeek.", carton/tryBox);
            }
         }
   Console::WriteLine();
   return 0;
}
