// Cw8_10.cpp: main project file.
// Definiowanie i uywanie operatorw przeadowanych.

#include "stdafx.h"
using namespace System;

ref class Length
{
private:
  int metry;
  int centymetry;

public:
  static initonly int cmNaMetr = 100;

  // Konstruktor.
  Length(int m, int cm) : metry(m), centymetry(cm){ }

  // Dugo jako acuch.
  virtual String^ ToString() override
  { return metry+L" metrw " + centymetry + L" centymetrw";  }

  // Przeadowany operator dodawania.
  Length^ operator+(Length^ len)
  {
    int cmTotal = centymetry + len->centymetry + cmNaMetr * ( metry + len->metry );
    return gcnew Length(cmTotal / cmNaMetr, cmTotal % cmNaMetr);
  }

  // Przeadowany operator dzielenia  prawy operand typu double.
  static Length^ operator/(Length^ len, double x)
  {
    int ins = safe_cast<int>((len->metry * cmNaMetr + len->centymetry)/x);
    return gcnew Length(ins / cmNaMetr, ins % cmNaMetr);
  }

  // Przeadowany operator dzielenia  oba operandy typu Length.
  static int operator/(Length^ len1, Length^ len2)
  {
    return (len1->metry * cmNaMetr + len1->centymetry)/
                                      (len2->metry * cmNaMetr + len2->centymetry);
  }

  // Przeadowany operator dzielenia modulo.
  static Length^ operator%(Length^ len1, Length^ len2)
  {
    int ins = (len1->metry * cmNaMetr + len1->centymetry)%
                                       (len2->metry * cmNaMetr + len2->centymetry);
    return gcnew Length(ins / cmNaMetr, ins % cmNaMetr);
  }

  static Length^ operator*(double x, Length^ len); // Mnoenie  prawy operand double.
  static Length^ operator*(Length^ len, double x); // Mnoenie  lewy operand double. 

  // Przedrostkowy i przyrostkowy operator inkrementacji.
  static Length^ operator++(Length^ len)
  {
    ++len->centymetry;
    len->metry += len->centymetry / len->cmNaMetr;
    len->centymetry %= len->cmNaMetr;
    return len;
  }
};

// Implementacja operatora mnoenia  prawy operand double.
Length^ Length::operator*(double x, Length^ len)
{
  int ins = safe_cast<int>(x * len->centymetry + x * len->metry*cmNaMetr);
  return gcnew Length(ins / cmNaMetr, ins % cmNaMetr);
}

// Implementacja operatora mnoenia  lewy operand double.
Length^ Length::operator*(Length^ len, double x)
{ return operator*(x, len);  }

int main(array<System::String ^> ^args)
{
  Length^ len1 = gcnew Length(2,60);              // 2 metry 60 centymetrw.
  Length^ len2 = gcnew Length(3,50);              // 3 metry 50 centymetrw.
  Length^ len3 = gcnew Length(14,60);             // 14 metrw 60 centymetrw.

  // Uycie operatorw +, * oraz /.
  Length^ total = 12*(len1+len2+len3) + (len3/gcnew Length(1,7))*len2;
  Console::WriteLine(total);

  // Uycie operatora dzielenia modulo.
  Console::WriteLine(
              L"{0} mona poci na {1} kawakw o dugoci {2}. Zostanie kawaek dugoci {3}.",
                                               len3, len3/len1, len1, len3%len1);
  Length^ len4 = gcnew Length(1, 11);            // 1 metr 11 centymetrw.

  // Uycie operatora inkrementacji w formie przedrostkowej i przyrostkowej.
  Console::WriteLine(len4++);                    // Uycie operatora w formie przyrostkowej.
  Console::WriteLine(++len4);                    // Uycie operatora w formie przedrostkowej.
  return 0;
}
