#include ".\Box.h"

CBox::CBox(double lv, double wv, double hv)

{
  lv = lv <= 0.0 ? 1.0 : lv;           // Sprawdzanie, czy
  wv = wv <= 0.0 ? 1.0 : wv;           // podane wymiary obiektu
  hv = hv <= 0.0 ? 1.0 : hv;           // maj wartoci dodatnie.

  m_Length = lv>wv ? lv : wv;          // Sprawdzanie, czy
  m_Width = wv<lv ? wv : lv;           // length >= width.
  m_Height = hv;
}

CBox::~CBox(void)
{
}


// Przeadowany operator dodawania.
CBox CBox::operator+(const CBox& aBox) const
{
  // Nowy obiekt jest duszy i szerszy od tych dwch,
  // i sumy ich wysokoci.
  return CBox(m_Length > aBox.m_Length ? m_Length : aBox.m_Length,
              m_Width > aBox.m_Width ? m_Width : aBox.m_Width,
              m_Height + aBox.m_Height);
}

// Mnoenie obiektu klasy CBox przez liczb cakowit.
CBox CBox::operator*(int n) const
{
  if(n%2)
    return CBox(m_Length, m_Width, n*m_Height);           // Mnonik n jest nieparzysty.
  else
    return CBox(m_Length, 2.0*m_Width, (n/2)*m_Height);   // Mnonik n jest parzysty.
}

// Dzielenie jednego obiektu przez drugi.
int CBox::operator/(const CBox& aBox) const
{
  // Tymczasowa zmienna przechowujca liczb w paszczynie poziomej w jeden sposb.
  int tc1 = 0;
  // Tymczasowa zmienna przechowujca liczb w paszczynie w inny sposb.
  int tc2 = 0;

  tc1 = static_cast<int>((m_Length/aBox.m_Length))*
         static_cast<int>((m_Width/aBox.m_Width)); 	 // Dopasowanie w jeden sposb

  tc2 = static_cast<int>((m_Length/aBox.m_Width))*
        static_cast<int>((m_Width/aBox.m_Length));	 // i w drugi sposb.

  // Zwraca najlepsze dopasowanie.
  return static_cast<int>((m_Height/aBox.m_Height))*(tc1>tc2 ? tc1 : tc2);
}
