// Cw8_06.cpp
// Dodawanie obiektw klasy CBox.
#include <iostream>                    // Dla strumienia wejcia-wyjcia.
using std::cout;
using std::endl;

class CBox                             // Definicja klasy o zasigu globalnym.
{
  public:
    // Definicja konstruktora.
    CBox(double lv = 1.0, double wv = 1.0, double hv = 1.0): m_Height(hv)
    {
      m_Length = lv > wv? lv: wv;      // Upewnienie si, e 
      m_Width = wv < lv? wv: lv;       // length >= width.
    }

    // Funkcja obliczajca pojemno pudeka.
    double Volume() const
    {
      return m_Length*m_Width*m_Height;
    }

    // Funkcja operatora wikszoci
    // porwnujca pojemnoci obiektw klasy CBox.
    int CBox::operator>(const CBox& aBox) const
    {
      return this->Volume() > aBox.Volume();
    }

    // Funkcja porwnujca obiekt klasy CBox ze sta.
    int operator>(const double& value) const
    {
      return Volume() > value;
    }

    // Funkcja dodajca dwa obiekty klasy CBox.
    CBox operator+(const CBox& aBox) const
    {
      // Nowy obiekt zoony z duszej dugoci i szerokoci oraz sumy wysokoci.
      return CBox(m_Length > aBox.m_Length? m_Length:aBox.m_Length,
                  m_Width > aBox.m_Width? m_Width:aBox.m_Width,
                  m_Height + aBox.m_Height);
    }

    // Funkcja pokazujca wymiary pudeka.
    void ShowBox() const
    {
      cout << m_Length << " " 
           << m_Width  << " " 
           << m_Height << endl;
    }

  private:
    double m_Length;                   // Dugo pudeka w centymetrach.
    double m_Width;                    // Szeroko pudeka w centymetrach.
    double m_Height;                   // Wysoko pudeka w centymetrach.
};

int operator>(const double& value, const CBox& aBox); // Prototyp funkcji.

int main()
{
  CBox smallBox(4.0, 2.0, 1.0);
  CBox mediumBox(10.0, 4.0, 2.0);
  CBox aBox;
  CBox bBox;

  aBox = smallBox + mediumBox;
  cout << "Wymiary obiektu aBox: ";
  aBox.ShowBox();

  bBox = aBox + smallBox + mediumBox;
  cout << "Wymiary obiektu bBox: ";
  bBox.ShowBox();

  return 0;
}

// Funkcja porwnujca sta z obiektem klasy CBox.
int operator>(const double& value, const CBox& aBox)
{
  return value > aBox.Volume();
}
