// Soln7_6.cpp

#include <iostream>                   // Dla funkcji wejcia-wyjcia.
#include <cstring>

using std::cout;
using std::endl;

class CTrace
{
public:
   CTrace(const char* str);
   ~CTrace();
private:
   char* pstr;
   static int indentLevel;
};

int CTrace::indentLevel = 0;

CTrace::CTrace(const char* str)
{
   indentLevel += 2;

   size_t len = strlen(str)+1;
   pstr = new char[len];
   strcpy_s(pstr, len, str);

   for(int i = 0; i<indentLevel ; i++)
      cout << ' ';
   cout << "Wejcie do funkcji: " << pstr << endl;
}

CTrace::~CTrace()
{
  for(int i = 0 ; i<indentLevel ; i++)
    cout << ' ';
  cout << "Wyjcie z funkcji: " << pstr << endl;

   delete pstr;
   pstr = NULL;
   indentLevel -= 2;
}

int main()
{
   CTrace trace("Procedura gwna");

   if (3 > 5)
   {
      CTrace trace1("wejcie do bloku 'if'");
   }
   else
   {
      CTrace trace2("wejcie do bloku 'else'");
   }

   return 0;
}
