// Cw7_13.cpp
// wiczenie zastosowania operatora poredniego dostpu do skadowych klasy.
#include <iostream>
using std::cout;
using std::endl;

class CBox                             // Definicja klasy o zasigu globalnym.
{
  public:
    // Definicja konstruktora.
    CBox(double lv = 1.0, double bv = 1.0, double hv = 1.0)
    {
      cout << endl << "Konstruktor zosta wywoany.";
      m_Length = lv;                   // Ustawianie wartoci
      m_Width = bv;                    // zmiennych skadowych.
      m_Height = hv;
    }

    // Funkcja obliczajca pojemno pudeka.
    double Volume() const
    {
      return m_Length*m_Width*m_Height;
    }

    // Funkcja porwnujca dwa pudeka, ktra zwraca true (1),
    // jeeli pierwsze jest wiksze ni drugie, oraz false (0) w przeciwnym przypadku.
    int Compare(CBox* pBox) const
    {
      return this->Volume() > pBox->Volume();
    }

  private:
    double m_Length;                   // Dugo pudeka w centymetrach.
    double m_Width;                    // Szeroko pudeka w centymetrach.
    double m_Height;                   // Wysoko pudeka w centymetrach.
};

int main()
{
  CBox boxes[5];                       // Deklaracja tablicy obiektw klasy CBox.
  CBox match(2.2, 1.1, 0.5);           // Deklaracja obiektu match.
  CBox cigar(8.0, 5.0, 1.0);           // Deklaracja obiektu cigar.
  CBox* pB1 = &cigar;                  // Inicjalizacja wskanika do adresu obiektu cigar.
  CBox* pB2 = 0;                       // Inicjalizacja wskanika do klasy CBox wartoci null.

  cout << endl 
       << "Adres obiektu cigar to " << pB1     // Wywietlanie adresw.
       << endl
       << "Pojemno pudeka cigar to "
       << pB1->Volume();                    // Pojemno wskazywanych obiektw.

  pB2 = &match;
  if(pB2->Compare(pB1))                     // Porwnywanie poprzez wskaniki.
    cout << endl
         << "Pudeko match jest wiksze ni cigar";
  else
    cout << endl
         << "Pudeko match jest mniejsze lub rwne cigar";

  pB1 = boxes;                              // Ustawienie na adres tablicy.
  boxes[2] = match;                         // Ustawienie trzeciego elementu tablicy na match.
  cout << endl                              // Dostp poprzez wskanik.
       << "Pojemno pudeka boxes[2] to " << (pB1 + 2)->Volume();

  cout << endl;
  return 0;
}
