// Cw7_01.cpp
// wiczenie struktur na podwrku.
#include <iostream>
using std::cout;
using std::endl;

// Definicja struktury reprezentujcej prostokty.
struct RECTANGLE
{
  int Left;                            // Para wsprzdnych
  int Top;                             // punktu znajdujcego si w lewym grnym rogu.

  int Right;                           // Para wsprzdnych
  int Bottom;                          // punktu znajdujcego si w prawym dolnym rogu podwrka.
};

// Prototyp funkcji obliczajcej powierzchni prostokta.
long Area(RECTANGLE& aRect);

// Prototyp funkcji przesuwajcej prostokt.
void MoveRect(RECTANGLE& aRect, int x, int y);

int main(void)
{
  RECTANGLE Yard = { 0, 0, 100, 120 };
  RECTANGLE Pool = { 30, 40, 70, 80 };
  RECTANGLE Hut1, Hut2;

  Hut1.Left = 70;
  Hut1.Top = 10;
  Hut1.Right = Hut1.Left + 25;
  Hut1.Bottom = 30;

  Hut2 = Hut1;                         // Definicja przypisujca Hut2 warto Hut1.
  MoveRect(Hut2, 10, 90);              // Teraz przesu w prawo.

  cout << endl
       << "Wsprzdne chaty Hut2 to "
       << Hut2.Left << "," << Hut2.Top << " i "
       << Hut2.Right << "," << Hut2.Bottom;

  cout << endl
       << "Powierzchnia podwrka wynosi "
       << Area(Yard);

  cout << endl
       << "Powierzchnia basenu wynosi "
       << Area(Pool)
       << endl;

  return 0;
}

// Funkcja obliczajca powierzchni prostokta.
long Area(RECTANGLE& aRect)
{
  return (aRect.Right - aRect.Left)*(aRect.Bottom - aRect.Top);
}

// Funkcja przesuwajca prostokt.
void MoveRect(RECTANGLE& aRect, int x, int y)
{
  int length = aRect.Right - aRect.Left;    // Pobierz dugo prostokta.
  int width = aRect.Bottom - aRect.Top;     // Pobierz szeroko prostokta.

  aRect.Left = x;                           // Ustaw lewy grny punkt
  aRect.Top = y;                            // w nowej lokalizacji.
  aRect.Right = x + length;                 // Wsprzdne punktu prawego dolnego rogu oblicz jako
  aRect.Bottom = y + width;                 // przyrost od nowego pooenia.

  return;
}
