// Ex6_5CLR.cpp : main project file.
// A CLR calculator supporting parentheses

#include "stdafx.h"
#include <cstdlib>                          // Dla funkcji exit().

using namespace System;
String^ eatspaces(String^ str);             // Funkcja usuwajca biae znaki.
double expr(String^ str);                   // Funkcja obliczajca wyraenie.
double term(String^ str, int^ index);       // Funkcja analizujca skadnik.
double number(String^ str, int^ index);     // Funkcja rozpoznajca liczby.
String^ extract(String^ str, int^ index);   // Funkcja wydobywajca podacuch.
void error(String^ str, int index);         // Funkcja identyfikujca bd.
double doOperation(String^ op, double value);   // Wykonuje funkcj matematyczn.

int main(array<System::String ^> ^args)
{
  String^ buffer;    // Miejsce na wyraenie do obliczenia.

   
  Console::WriteLine(L"Witaj w swoim przyjaznym kalkulatorze..");
  Console::WriteLine(L"Wprowad wyraenie lub pusty wiersz, aby zakoczy.");

  for(;;)
  {
    buffer = eatspaces(Console::ReadLine());         // Wczytanie wiersza danych.

    if(String::IsNullOrEmpty(buffer))                // Pusty wiersz powoduje zakoczenie dziaania kalkulatora.
      return 0;

    Console::WriteLine(L"  = {0}\n\n",expr(buffer)); // Wysanie na wyjcie wartoci wyraenia.
  }
  return 0;
}

// Funkcja usuwajca spacje z acucha.
String^ eatspaces(String^ str)
{
  // Tablica przechowujca acuch bez spacji.  
  array<wchar_t>^ chars = gcnew array<wchar_t>(str->Length);
  int length = 0;                      // Liczba znakw w tablicy.

  // Kopiuje znaki nie bedce spacjami do tablicy znakw.
  for each(wchar_t ch in str)
    if(ch != ' ')
      chars[length++] = ch;

  // Zwraca tablic chars jako acuch.
  return gcnew String(chars, 0, length);
}

// Funkcja obliczajca wyraenie arytmetyczne.
double expr(String^ str)
{
  int^ index = 0;                      // Pilnuje pozycji aktualnego znaku.

  double value = term(str, index);     // Pobiera pierwszy skadnik.

  while(*index < str->Length)
  {
    switch(str[*index])                / Podejmuje dziaania na podstawie biecego znaku.
    {
      case '+':                        // Znaleziono znak +, a wic 
         ++(*index);                   // zwikszamy indeks i dodajemy
         value += term(str, index);    // nastpny skadnik.
         break;

      case '-':                        // Znaleziono znak -, a wic 
          ++(*index);                  // zmniejszamy indeks i odejmujemy
        value -= term(str, index);     // nastpny skadnik.
         break;

      default:                         Jeli doszlimy tutaj, podany acuch jest bdny. is junk
        Console::WriteLine(L"Arrrgh!*#!! Tu jest bd.\n");
        error(str, *index-1);
        exit(1);
    }
  }
  return value;
}

// Funkcja obliczajca warto skadnika.
double term(String^ str, int^ index)
{
  double value = number(str, index);        // Pobranie pierwszej liczby skadnika.

  // Ptla dziaajca dopki s znaki i dobry operator.
  while(*index < str->Length)
  {
    if(str[*index] == L'*')                 // Jeli jest operator mnoenia,
    {
      ++(*index);                           // zwikszamy indeks
      value *= number(str, index);          // mnoymy przez nastpn liczb.
    }
    else if( str[*index] == L'/')           // Jeli dzielenia,
    {
      ++(*index);                           // zwikszamy indeks i
      value /= number(str, index);          // dzielimy przez nastpn liczb.
    }
    else if( str[*index] == L'^')                    // Jeli potgowania,
    {
      ++(*index);                                    // zwikszamy indeks
      value = Math::Pow(value, number(str, index));  // i podnosimy do potgi odpowiadajcej nastpnej liczbie.
    }
    else
      break;                                // Koniec ptli.
 }
  // Skoczylimy, a wic zwracamy, co mamy.
  return value;                             
}

// Funkcja rozpoznajca liczby.
double number(String^ str, int^ index)
{
  double value = 0.0;                       // Przechowuje wynik.

  // Szukanie nazwy funkcji matematycznej.
  String^ op = "";
  while (Char::IsLetter(str,*index))      // Skopiowanie tej nazwy.
  {
    op += str[*index];
    ++(*index);
  }

  // Sprawdza wyraenie pomidzy nawiasami.
  if(str[*index] == L'(' )                  // Nawias otwierajcy.
  {
    ++(*index);
    String^ substr = extract(str, index);   // Wydobycie podacucha w nawiasach.
    if(op->Length > 0)
      return doOperation(op, expr(substr));
    else
      return expr(substr);                    // Zwrcenie wartoci podacucha.
  }

  // Ptla zbierajca wiodce cyfry.
  while((*index < str->Length) && Char::IsDigit(str, *index))
  {
    value = 10.0*value + Char::GetNumericValue(str[(*index)]);
    ++(*index);
  }

  // Jeli jestemy tu, znalelimy co innego ni cyfra.
  if((*index == str->Length) || str[*index] != '.')   // Sprawdzamy czy jest to przecinek dziesitny.
    return value;                                     // Jeli nie, zwracamy warto.

  double factor = 1.0;                 
  ++(*index);                          // Przejcie do cyfry.

  // Ptla dziaajca dopki s cyfry.
  while((*index < str->Length) && Char::IsDigit(str, *index))   
  {
    factor *= 0.1;                     
    value = value + Char::GetNumericValue(str[*index])*factor; // Dodanie miejsca dziesitnego.
    ++(*index);
  }

  return value;                        // Po zakoczeniu dziaania ptli, koniec.
}

// Funkcja wydobywajca podacuch z nawiasw. 
String^ extract(String^ str, int^ index)
{
  // Tymczasowe miejsce do przechowania podacucha.
  array<wchar_t>^ buffer = gcnew array<wchar_t>(str->Length); 
  String^ substr;                      // Podacuch do zwrcenia.
  int numL = 0;                        // Licznik nawiasw otwierajcych.
  int bufindex = *index;               // Zapisanie wartoci pocztkowej dla indeksu

  while(*index < str->Length)
  {
    buffer[*index - bufindex] = str[*index];
    switch(str[*index])
    {
      case ')':
        if(numL == 0)
        {
          array<wchar_t>^ substrChars = gcnew array<wchar_t>(*index - bufindex);
          str->CopyTo(bufindex, substrChars, 0, substrChars->Length);
          substr = gcnew String(substrChars);
          ++(*index);

          return substr;               // Zwrcenie tego podacucha.
        }
        else
          numL--;                      // Zmniejszenie licznika nawiasw otwierajcych.
        break;

      case '(':
        numL++;                        // Zwikszenie licznika nawiasw otwierajcych. 
                                       
        break;
      }
    ++(*index);
  }

  Console::WriteLine(L"Nastpio wyjcie poza koniec wyraenia, dane wejciowe musz by niepoprawne.");
  exit(1);
  return substr;
}

// Funkcja identyfikujca bd.
void error(String^ str, int index)
{
   Console::WriteLine(str);
   Console::Write(gcnew String(' ',index));
   Console::WriteLine(" ^");
}

// Wykonuje funkcj matematyczn.
double doOperation(String^ op, double value)
{
  double degToRad = 180.0/Math::PI;
  if (String::Compare(op, L"sin", true) == 0)
    return Math::Sin(value);
   else if (String::Compare(op, L"sind", true) == 0)
      return Math::Sin(value/degToRad);
   else if (String::Compare(op, L"cos", true) == 0)
      return Math::Cos(value);
   else if (String::Compare(op, L"cosd", true) == 0)
      return Math::Cos(value/degToRad);
   else if (String::Compare(op, L"tan", true) == 0)
     return Math::Tan(value);
   else if (String::Compare(op, L"tand", true) == 0)
      return Math::Tan(value/degToRad);
   else if (String::Compare(op, L"sqrt", true) == 0)
     return Math::Sqrt(value);
   else
   {
     Console::WriteLine(L"Bd: nieznana operacja '" + op + "'");
     exit(1);
   }
   return 0;
}
