// Ex6_3CLR.cpp : main project file.
// Klakulator CLR obsugujcy nawiasy.

#include "stdafx.h"
#include <cstdlib>                          // Dla funkcji exit().

using namespace System;
String^ eatspaces(String^ str);             // Funkcja usuwajca biae znaki.
double expr(String^ str);                   // Funkcja obliczajca warto wyraenia.
double term(String^ str, int^ index);       // Funkcja analizujca skadnik.
double number(String^ str, int^ index);     // Funkcja rozpoznajca liczb.
String^ extract(String^ str, int^ index);   // Funkcja wydobywajca podacuch.
void error(String^ str, int index);         // Funkcja identyfikujca bd.
int main(array<System::String ^> ^args)
{
  String^ buffer;    // Miejsce na wyraenia do obliczenia.

   
  Console::WriteLine(L"Witaj w swoim przyjaznym kalkulatorze.");
  Console::WriteLine(L"Wprowad wyraenie lub pusty wiersz, aby zakoczy.");

  for(;;)
  {
    buffer = eatspaces(Console::ReadLine());         // Wczytanie wiersza danych.

    if(String::IsNullOrEmpty(buffer))                // Pusty wiersz powoduje zakoczenie dziaania kalkulatora.
      return 0;

    Console::WriteLine(L"  = {0}\n\n",expr(buffer)); // Wysanie na wyjcie wartoci wyraenia.
  }
  return 0;
}

// Funkcja usuwajca spacje z acucha.
String^ eatspaces(String^ str)
{
  // Tablica przechowujca acuch bez spacji. 
  array<wchar_t>^ chars = gcnew array<wchar_t>(str->Length);
  int length = 0;                      // Liczba znakw w tablicy.

  // Kopiuje znaki nie bdce spacj do tablicy znakw.
  for each(wchar_t ch in str)
    if(ch != ' ')
      chars[length++] = ch;

  // Zwraca tablic chars jako acuch.
  return gcnew String(chars, 0, length);
}

// Funkcja obliczajca wyraenie arytmetyczne.
double expr(String^ str)
{
  int^ index = 0;                      // Pilnuje pozycji aktualnego znaku.

  double value = term(str, index);     // Pobiera pierwszy skadnik.

  while(*index < str->Length)
  {
    switch(str[*index])                // Podejmuje dziaania na podstawie biecego znaku.
    {
      case '+':                        // Znaleziono znak +, a wic 
         ++(*index);                   // zwikszamy indeks i
         value += term(str, index);    // dodajemy nastpny skadnik.
         break;

      case '-':                        // Znaleziono znak -, a wic
          ++(*index);                  // zmniejszamy indeks i
        value -= term(str, index);     // odejmujemy nastpny skadnik.
         break;

      default:                         // Jeli doszlimy tutaj, podany acuch jest bdny.
        Console::WriteLine(L"Arrrgh!*#!! Tu jest bd.\n");
        error(str, *index-1);
        exit(1);
    }
  }
  return value;
}

// Funkcja obliczajca warto skadnika.
double term(String^ str, int^ index)
{
  double value = number(str, index);        // Pobranie pierwszej liczby skadnika.

  // Ptla dziaa dopki jest dobry operator i s wartoci.
  while(*index < str->Length)
  {
    if(str[*index] == L'*')                 // Jeli jest operator mnoenia,
    {
      ++(*index);                           // zwikszamy indeks i
      value *= number(str, index);          // mnoymy przez nastpn liczb.
    }
    else if( str[*index] == L'/')           // Jeli dzielenia,
    {
      ++(*index);                           // zwikszamy indeks i
      value /= number(str, index);          // dzielimy przez nastpn liczb.
    }
    else
      break;                                // koniec ptli.
 }
  // Skoczylimy, a wic zwracamy, co mamy.
  return value;                             
}

// Funkcja rozpoznajca liczby.
double number(String^ str, int^ index)
{
  double value = 0.0;                       // Zapisanie wartoci.

  // Sprawdzenie czy jest wyraenie w nawiasach.
  if(str[*index] == L'(' )                  // Nawias otwierajcy.
  {
    ++(*index);
    String^ substr = extract(str, index);   // Wydobycie podacucha w nawiasach.
    return expr(substr);                    // Zwrcenie wartoci podacucha.
  }

  // Ptla zbierajca wiodce cyfry.
  while((*index < str->Length) && Char::IsDigit(str, *index))
  {
    value = 10.0*value + Char::GetNumericValue(str[(*index)]);
    ++(*index);
  }

  // Jeli jestemy tu, znalelimy co innego ni cyfra.
  if((*index == str->Length) || str[*index] != '.')   // Sprawdzamy czy jest to przecinek dziesitny.
    return value;                                     // Jeli nie, zwracamy warto.

  double factor = 1.0;                 
  ++(*index);                          

  //Ptla dziaajca dopki s cyfry.
  while((*index < str->Length) && Char::IsDigit(str, *index))   
  {
    factor *= 0.1;                     
    value = value + Char::GetNumericValue(str[*index])*factor; // Dodanie miejsca dziesitnego.
    ++(*index);
  }

  return value;                        // Po zakoczeniu dziaania ptli, koniec.
}

// Funkcja wydobywajca podacuch z nawiasw. 
String^ extract(String^ str, int^ index)
{
  // Tymczasowe miejsce do przechowania podacucha.
  array<wchar_t>^ buffer = gcnew array<wchar_t>(str->Length); 
  String^ substr;                      // Podacuch do zwrcenia.
  int numL = 0;                        // Licznik otwierajcyh nawiasw.
  int bufindex = *index;               

  while(*index < str->Length)
  {
    buffer[*index - bufindex] = str[*index];
    switch(str[*index])
    {
      case ')':
        if(numL == 0)
        {
          array<wchar_t>^ substrChars = gcnew array<wchar_t>(*index - bufindex);
          str->CopyTo(bufindex, substrChars, 0, substrChars->Length);
          substr = gcnew String(substrChars);
          ++(*index);

          return substr;               // Zwrcenie podacucha w nowym obszarze pamici.
        }
        else
          numL--;                      // Zmniejszenie licznika nawiasw otwierajcych.
        break;

      case '(':
        numL++;                        // Zwikszenie licznika nawiasw otwierajcych.
        break;
      }
    ++(*index);
  }

  Console::WriteLine(L"Nastpio wyjcie poza koniec wyraenia, dane wejciowe musz by niepoprawne.");
  exit(1);
  return substr;
}

// Funkcja identyfikujca bd.
void error(String^ str, int index)
{
   Console::WriteLine(str);
   Console::Write(gcnew String(' ',index));
   Console::WriteLine(" ^");
}
