// Cw6_10.cpp: main project file.
// Definiowanie i uywanie funkcji generycznych.

#include "stdafx.h"

using namespace System;

// Funkcja generyczna znajdujca najwikszy element tablicy.
generic<typename T> where T:IComparable
T MaxElement(array<T>^ x)
{
  T max = x[0];
  for(int i = 1; i < x->Length; i++)
    if(max->CompareTo(x[i]) < 0)
       max = x[i];
  return max;
}

// Funkcja generyczna usuwajca element z tablicy.
generic<typename T> where T:IComparable
array<T>^ RemoveElement(T element, array<T>^ data)
{
  array<T>^ newData = gcnew array<T>(data->Length - 1);
  int index = 0;                      // Indeks do elementw tablicy newData.
  bool found = false;                  // Wskazuje, e zosta znaleziony element do usunicia.
  for each(T item in data)
  {
    // Sprawdzanie nieprawidowego indeksu lub znalezionego elementu.
    if((!found) && item->CompareTo(element) == 0)
    {
      found = true;
      continue;
    }
    else
    {
      if(index == newData->Length)
      {
        Console::WriteLine(L"Nie znaleziono elementu do usunicia");
        return data;
      }
      newData[index++] = item;
    }
  }
    return newData;
}

// Funkcja generyczna wywietlajca elementy tablicy.
generic<typename T> where T:IComparable
void ListElements(array<T>^ data)
{
  for each(T item in data)
    Console::Write(L"{0,10}", item);
  Console::WriteLine();
}

int main(array<System::String ^> ^args)
{
  array<double>^ data = {1.5, 3.5, 6.7, 4.2, 2.1};
  Console::WriteLine(L"Tablica zawiera:");
  ListElements(data);
  Console::WriteLine(L"\nNajwikszy element = {0}\n", MaxElement(data));
  array<double>^ result = RemoveElement(MaxElement(data), data);
  Console::WriteLine(L" Po usuniciu najwikszego elementu tablica zawiera:");
  ListElements(result);

  array<int>^ numbers = {3, 12, 7, 0, 10,11};
  Console::WriteLine(L"\nTablica zawiera:");
  ListElements(numbers);
  Console::WriteLine(L"\nNajwikszy element = {0}\n", MaxElement(numbers));
  Console::WriteLine(L"\nPo usuniciu najwikszego elementu tablica zawiera:");
  ListElements(RemoveElement(MaxElement(numbers), numbers));

  array<String^>^ strings = {L"Dwie", L"gowy", L"to", L"nie", L"jedna"};
  Console::WriteLine(L"\nTablica zawiera:");
  ListElements(strings);
  Console::WriteLine(L"\nNajwikszy element = {0}\n", MaxElement(strings));
  Console::WriteLine(L"\nPo usuniciu najwikszego elementu tablica zawiera:");
  ListElements(RemoveElement(MaxElement(strings), strings));

  return 0;
}

  Console::WriteLine(L"\nNajwikszy element = {0}\n", MaxElement(data));
  array<double>^ result = RemoveElement(MaxElement(data), data);
  Console::WriteLine(L" Po usunicie najwikszego elementu tablica zawiera:");
  ListElements(result);

  array<int>^ numbers = {3, 12, 7, 0, 10,11};
  Console::WriteLine(L"\nTablica zawiera:");
  ListElements(numbers);
  Console::WriteLine(L"\nNajwikszy element = {0}\n", MaxElement(numbers));
  Console::WriteLine(L"\nPo usuniciu najwikszego elementu tablica zawiera:");
  ListElements(RemoveElement(MaxElement(numbers), numbers));

  array<String^>^ strings = {L"Dwie", L"gowy", L"to", L"nie", L"jedna"};
  Console::WriteLine(L"\nTablica zawiera:");
  ListElements(strings);
  Console::WriteLine(L"\nNajwikszy element = {0}\n", MaxElement(strings));
  Console::WriteLine(L"\nPo usuniciu najwikszego elementu tablica zawiera:");
  ListElements(RemoveElement(MaxElement(strings), strings));

  return 0;
}
