#pragma once
#define DllImport __declspec( dllimport )

// Import element type declarations
// Each type value must be unique
DllImport extern const unsigned int LINE;
DllImport extern const unsigned int RECTANGLE;
DllImport extern const unsigned int CIRCLE;
DllImport extern const unsigned int CURVE;
DllImport extern const unsigned int TEXT;
///////////////////////////////////

// Import color values for drawing
DllImport extern const COLORREF BLACK;
DllImport extern const COLORREF RED;
DllImport extern const COLORREF GREEN;
DllImport extern const COLORREF BLUE;
DllImport extern const COLORREF SELECT_COLOR;
///////////////////////////////////

// CElement command target

class AFX_EXT_CLASS CElement : public CObject
{
   DECLARE_SERIAL(CElement)
   protected:
      COLORREF m_Color;                     // Kolor elementu
      CRect m_EnclosingRect;                // Prostokt opisujcy element
      int m_Pen;                            // Szeoko pira

   public:
      virtual ~CElement();                   // Wirtualny destruktor
      // Wirtualna operacja rysowania
      virtual void Draw(CDC* pDC,CElement* pElement=0) {}
      virtual void Move(CSize& aSize){}      // Przenie element
      CRect GetBoundRect();                  // Pobierz prostokt ograniczajcy element
      virtual void Serialize(CArchive& ar);  // Funkcja serializujca dla klasy

   protected:
      CElement();                            // Umieszczamy tutaj, aby zapobiec wywoaniu
}
class AFX_EXT_CLASS CLine :
  public CElement
{
   DECLARE_SERIAL(CLine)
   public:
      ~CLine(void);
      // Funkcja wywietlajca lini
      virtual void Draw(CDC* pDC, CElement* pElement=0);     

      // Konstruktor obiektu linii
      CLine(CPoint Start, CPoint End, COLORREF aColor, int PenWidth);

      // Funkcja przenoszca element
      virtual void Move(CSize& aSize);
      virtual void Serialize(CArchive& ar);  // Funkcja serializujca dla klasy

   protected:
      CPoint m_StartPoint;             // Punkt pocztkowy linii
      CPoint m_EndPoint;               // Punkt kocowy linii

      CLine(void);                     // Domylny konstruktor - nie powinien by uywany
};

class AFX_EXT_CLASS CRectangle :
  public CElement
{
   DECLARE_SERIAL(CRectangle)
   public:
      ~CRectangle(void);
      // Funkcja wywietlajca lini
      virtual void Draw(CDC* pDC, CElement* pElement=0);     

      // Konstruktor obiektu prostokta
      CRectangle(CPoint Start, CPoint End, COLORREF aColor, int PenWidth);

      // Funkcja przenoszca element
      virtual void Move(CSize& aSize);
      virtual void Serialize(CArchive& ar);  // Funkcja serializujca dla klasy

   protected:
      CRectangle(void);                // Domylny konstruktor - nie powinien by uywany
};


class AFX_EXT_CLASS CCircle :
  public CElement
{
   DECLARE_SERIAL(CCircle)
   public:
      ~CCircle(void);
      // Funkcja wywietlajca lini
      virtual void Draw(CDC* pDC, CElement* pElement=0);     

      // Konstruktor obiektu okrgu
      CCircle(CPoint Start, CPoint End, COLORREF aColor, int PenWidth);

      // Funkcja przenoszca element
      virtual void Move(CSize& aSize);
      virtual void Serialize(CArchive& ar);  // Funkcja serializujca dla klasy

   protected:
      CCircle(void);                   // Domylny konstruktor - nie powinien by uywany
};

class AFX_EXT_CLASS CCurve :
  public CElement
{
   DECLARE_SERIAL(CCurve)
   public:
      ~CCurve(void);
      // Funkcja wywietlajca lini
      virtual void Draw(CDC* pDC, CElement* pElement=0);     

      // Konstruktor obiektu krzywej
      CCurve(CPoint FirstPoint, CPoint SecondPoint, COLORREF aColor, int PenWidth);

      void AddSegment(CPoint& aPoint);       //Dodaje odcinek do krzywej

      // Funkcja przenoszca element
      virtual void Move(CSize& aSize);
      virtual void Serialize(CArchive& ar);  // Funkcja serializujca dla klasy

   protected:
      CCurve(void);                          // Domylny konstruktor - nie powinien by uywany
      CList<CPoint, CPoint&> m_PointList;    // Lista z kontrol typw
};

// Klasa definiujca obiekt tekstu
class AFX_EXT_CLASS CText: public CElement
{
  DECLARE_SERIAL(CText)
  public:
    // Funkcja wywietlajca element tekstowy
    virtual void Draw(CDC* pDC, CElement* pElement=0);

    // Konstruktorelementu tekstowego
    CText(CPoint Start, CPoint End, CString aString, COLORREF aColor);
    virtual void Move(CSize& aSize);       // Przenosi element tekstowy
    virtual void Serialize(CArchive& ar);  // Funkcja serializujca dla klasy
  protected:
    CPoint m_StartPoint;                   // pozycja elementu tekstowego
    CString m_String;                      // Tekst do wywietlenia
    CText(){}                              // Domylny konstruktor
};

