#pragma once

// CElement command target

class CElement : public CObject
{
   protected:
      COLORREF m_Color;                  // Kolor elementu
      CRect m_EnclosingRect;             // Prostokt opisujcy element
      int m_Pen;                         // Szeoko pira

   public:
      virtual ~CElement();               // Wirtualny destruktor
      // Wirtualna operacja rysowania
      virtual void Draw(CDC* pDC,CElement* pElement=0) {}
      virtual void Move(CSize& aSize){}  // Przenie element
      CRect GetBoundRect();       // Pobierz prostokt ograniczajcy element

   protected:
      CElement();                        // Umieszczamy tutaj, aby zapobiec wywoaniu
};

class CLine :
  public CElement
{
   public:
      ~CLine(void);
      // Funkcja wywietlajca lini
      virtual void Draw(CDC* pDC, CElement* pElement=0);     

      // Konstruktor obiektu linii
      CLine(CPoint Start, CPoint End, COLORREF aColor);

      // Funkcja przenoszca element
      virtual void Move(CSize& aSize);

   protected:
      CPoint m_StartPoint;             // Punkt pocztkowy linii
      CPoint m_EndPoint;               // Punkt kocowy linii

      CLine(void);                     // Domylny konstruktor - nie powinien by uywany
};

class CRectangle :
  public CElement
{
   public:
      ~CRectangle(void);
      // Funkcja wywietlajca lini
      virtual void Draw(CDC* pDC, CElement* pElement=0);     

      // Konstruktor obiektu prostokta
      CRectangle(CPoint Start, CPoint End, COLORREF aColor);

      // Funkcja przenoszca element
      virtual void Move(CSize& aSize);

   protected:
      CRectangle(void);                // Domylny konstruktor - nie powinien by uywany
};

class CCircle :
  public CElement
{
   public:
      ~CCircle(void);
      // Funkcja wywietlajca lini
      virtual void Draw(CDC* pDC, CElement* pElement=0);     

      // Konstruktor obiektu okrgu
      CCircle(CPoint Start, CPoint End, COLORREF aColor);

      // Funkcja przenoszca element
      virtual void Move(CSize& aSize);

   protected:
      CCircle(void);                   // Domylny konstruktor - nie powinien by uywany
};

class CCurve :
  public CElement
{
   public:
      ~CCurve(void);
      // Funkcja wywietlajca lini
      virtual void Draw(CDC* pDC, CElement* pElement=0);     

      // Konstruktor obiektu krzywej
      CCurve(CPoint FirstPoint, CPoint SecondPoint, COLORREF aColor);

      void AddSegment(CPoint& aPoint);    //Dodaje odcinek do krzywej

      // Funkcja przenoszca element
      virtual void Move(CSize& aSize);

   protected:
      CCurve(void);                    // Domylny konstruktor - nie powinien by uywany
      // Lista wskanikw do punktw z kontrol typw
      CTypedPtrList<CPtrList, CPoint*> m_PointPtrList;
};


