// Cw11_01.cpp   Natywny program Windows, wywietlajcy tekst w oknie.

#include <windows.h>

LRESULT WINAPI WindowProc(HWND hWnd, UINT message,
                          WPARAM wParam, LPARAM lParam);

// Tutaj wstaw kod funkcji WinMain() (Listing OFWIN_1).
// Listing OFWIN_1
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
  WNDCLASSEX WindowClass;                  // Struktura przechowujca atrybuty okna.

  static LPCTSTR szAppName = L"OFWin";     // Zdefiniuj nazw klasy okna.
  HWND hWnd;                               // Uchwyt okna.
  MSG msg;                                 // Struktura komunikatu Windowsa.

  WindowClass.cbSize = sizeof(WNDCLASSEX); // Ustaw rozmiar struktury.

  // Przerysuj okno, jeli zostanie zmieniony jego rozmiar.
  WindowClass.style = CS_HREDRAW | CS_VREDRAW;

  // Zdefiniuj funkcj obsugujc komunikaty.
  WindowClass.lpfnWndProc = WindowProc;

  WindowClass.cbClsExtra = 0;              // Nie ma dodatkowych bajtw po strukturze klasy okna
  WindowClass.cbWndExtra = 0;              // ani po instancji okna.

  WindowClass.hInstance = hInstance;       // Uchwyt instancji aplikacji.
  
  // Ustaw domyln ikon aplikacji.
  WindowClass.hIcon = LoadIcon(0, IDI_APPLICATION);

  // Ustaw standardow strzak jako kursor.
  WindowClass.hCursor = LoadCursor(0, IDC_ARROW);

  // Ustaw szary pdzel dla koloru ta.
  WindowClass.hbrBackground = static_cast<HBRUSH>(GetStockObject(GRAY_BRUSH));
  WindowClass.lpszMenuName = 0;            // Brak menu.
  WindowClass.lpszClassName = szAppName;   // Ustaw nazw klasy.
  WindowClass.hIconSm = 0;                 // Domylna maa ikona.

  // Zarejestruj klas okna.
  RegisterClassEx(&WindowClass);

  // Teraz mona utworzy okno.
  hWnd = CreateWindow(
  szAppName,                               // Nazwa klasy okna.
  L"Podstawowe okno  trudny sposb",       // Tytu okna.
  WS_OVERLAPPEDWINDOW,                     // Styl okna (tu: nakadkowy).
  CW_USEDEFAULT,                           // Domylna pozycja lewego grnego...
  CW_USEDEFAULT,                           // ...naronika okna jako x, y...
  CW_USEDEFAULT,                           // Domylny rozmiar okna. 
  CW_USEDEFAULT,                           // ...
  0,                                       // Brak okna gwnego (macierzystego).
  0,                                       // Brak menu.
  hInstance,                               // Uchwyt instancji programu.
  0                                        // Brak dodatkowych danych tworzenia okna.
  );

  ShowWindow(hWnd, nCmdShow);              // Wywietl okno.
  UpdateWindow(hWnd);                      // Powoduje przerysowanie obszaru klienta.

   // Ptla komunikatw.
 while(GetMessage(&msg, 0, 0, 0) == TRUE)  // Pobieraj komunikaty.
  {
    TranslateMessage(&msg);                // Przetumacz komunikat.
    DispatchMessage(&msg);                 // Wylij komunikat.
  }
  return static_cast<int>(msg.wParam);     // Koniec, wic zwr do Windowsa.
}

   // Tutaj wstaw kod funkcji WindowProc() here (Listing OFWIN_2)
// Listing OFWIN_2
LRESULT CALLBACK WindowProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  HDC hDC; // Uchwyt kontekstu wywietlacza.
  PAINTSTRUCT PaintSt; // Struktura definiujca obszar do przerysowania.
  RECT aRect; // Prostokt do odnowienia.
  switch(message) // Przetwarzaj wybrane komunikaty.
  {
  case WM_PAINT: // Komunikat o przerysowaniu okna.
    hDC = BeginPaint(hWnd, &PaintSt); // Przygotuj rysowanie okna.

    // Pobierz koordynaty lewego grnego i prawego grnego naronika obszaru klienta.
    GetClientRect(hWnd, &aRect);

    SetBkMode(hDC, TRANSPARENT); // Ustaw tryb ta tekstu.

    // Rysuj w obszarze klienta.
    DrawText(
      hDC, // Uchwyt kontekstu urzdzenia.
      L" By doj do rda, trzeba pyn pod prd.",
      -1, // Oznacza acuch zakoczony znakiem null.
      &aRect, // Prostokt, w ktrym ma zosta narysowany tekst.
      DT_SINGLELINE| // Format tekstu  pojedyncza linia.
      DT_CENTER| //                                   Wyrodkowany w linii.
      DT_VCENTER); //                              Linia wyrodkowana w aRect.

    EndPaint(hWnd, &PaintSt); // Zakocz przerysowywanie.
    return 0;

  case WM_DESTROY: // Okno jest niszczone.
    PostQuitMessage(0);
    return 0;

  default: // Kada inna wiadomo, o ktrej nie chcemy wiedzie, wic wywoaj domylne przetwarzanie komunikatw.
    return DefWindowProc(hWnd, message, wParam, lParam);
  }
}
