// Cw10_03.cpp: main project file.
// CLR  dane wyjciowe ledzenia i debugowania.

#include "stdafx.h"

using namespace System;
using namespace System::Diagnostics;

public ref class TraceTest
{
public:
  TraceTest(int n):value(n){}

  property TraceLevel Level
  {
    void set(TraceLevel level) {sw->Level = level; }
    TraceLevel get(){return sw->Level; }
  }

  void FunA()
  {
    ++value;
    Trace::Indent();
    Trace::WriteLine(L"Pocztek funkcji FunA.");
    if(sw->TraceInfo)
      Debug::WriteLine(L"Funkcja FunA w trakcie dziaania...");
    FunB();
    Trace::WriteLine(L"Koczenie funkcji FunA.");
    Trace::Unindent();
  }

  void FunB()
  {
    Trace::Indent();
    Trace::WriteLine(L"Pocztek funkcji FunB.");
    if(sw->TraceWarning)
      Debug::WriteLine(L"Ostrzeenie w funkcji FunB...");
    FunC();
    Trace::WriteLine(L"Koczenie funkcji FunB.");
    Trace::Unindent();
  }

  void FunC()
  {
    Trace::Indent();
    Trace::WriteLine(L"Pocztek funkcji FunC.");
    if(sw->TraceError)
      Debug::WriteLine(L"Bd w funkcji FunC...");
    Debug::Assert(value < 4);
    Trace::WriteLine(L"Koczenie funkcji FunC.");
    Trace::Unindent();
  }
private:
  int value;
  static TraceSwitch^ sw =
                      gcnew TraceSwitch(L"Przecznik ledzenia.", L"Kontroluje dane wyjciowe ledzenia.");
};

int main(array<System::String ^> ^args)
{
  // Skierowanie danych wyjciowych do wiersza polece.
  TextWriterTraceListener^ listener = gcnew TextWriterTraceListener( Console::Out);
  Debug::Listeners->Add(listener);

  Debug::IndentSize = 2;              // Ustawianie rozmiaru wcicia.

  array<TraceLevel>^ levels = { TraceLevel::Off,     TraceLevel::Error,
                                TraceLevel::Warning ,TraceLevel::Verbose};
  TraceTest^ obj = gcnew TraceTest(0);

  Console::WriteLine(L"Pocztek testu debugowania i ledzenia...");
  for each(TraceLevel level in levels)
  {
    obj->Level = level;                // Ustawianie poziomu dla komunikatw.
    Console::WriteLine(L"\nPoziom ledzenia to {0}", obj->Level);
    obj->FunA();
  }
 return 0;
}
