// Name.h  Definicja klasy Name
#pragma once

// Klasa definiujca imi i nazwisko osoby.
class Name
{
public:
  Name();                                        // Konstruktor domylny.
  Name(const char* pFirst, const char* pSecond); // Konstruktor.
  Name(const Name& rName);                       // Konstruktor kopiujcy.

  ~Name();                                       // Destruktor.

  char* getName(char* pName) const;              // Pobierz ca nazw.
  size_t getNameLength() const;                  // Pobierz dugo caej nazwy.

 // Operatory porwnania dla imion i nazwisk.    
   bool operator<(const Name& name) const;
   bool operator==(const Name& name) const;
   bool operator>(const Name& name) const;

   Name& operator=(const Name& rName);                 // Operator przypisania.
private:
  char* pFirstname;
  char* pSurname;
};